/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;

public class Schedule
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"Schedule\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Attributes for defining a job schedule\",\"fields\":[{\"name\":\"cronSchedule\",\"type\":\"string\",\"doc\":\"Schedule for flow in cron format\",\"validate\":{\"org.apache.gobblin.service.validator.CronValidator\":{}}},{\"name\":\"runImmediately\",\"type\":\"boolean\",\"doc\":\"Set to true to request that a job with a schedule be run immediately in addition to being scheduled\",\"default\":false}]}");
    private static final RecordDataSchema.Field FIELD_CronSchedule = SCHEMA.getField("cronSchedule");
    private static final RecordDataSchema.Field FIELD_RunImmediately = SCHEMA.getField("runImmediately");

    public Schedule() {
        super(new DataMap(), SCHEMA);
    }

    public Schedule(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasCronSchedule() {
        return this.contains(FIELD_CronSchedule);
    }

    public void removeCronSchedule() {
        this.remove(FIELD_CronSchedule);
    }

    public String getCronSchedule(GetMode mode) {
        return (String)this.obtainDirect(FIELD_CronSchedule, String.class, mode);
    }

    @Nonnull
    public String getCronSchedule() {
        return (String)this.obtainDirect(FIELD_CronSchedule, String.class, GetMode.STRICT);
    }

    public Schedule setCronSchedule(String value, SetMode mode) {
        this.putDirect(FIELD_CronSchedule, String.class, String.class, value, mode);
        return this;
    }

    public Schedule setCronSchedule(@Nonnull String value) {
        this.putDirect(FIELD_CronSchedule, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasRunImmediately() {
        return this.contains(FIELD_RunImmediately);
    }

    public void removeRunImmediately() {
        this.remove(FIELD_RunImmediately);
    }

    public Boolean isRunImmediately(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_RunImmediately, Boolean.class, mode);
    }

    @Nonnull
    public Boolean isRunImmediately() {
        return (Boolean)this.obtainDirect(FIELD_RunImmediately, Boolean.class, GetMode.STRICT);
    }

    public Schedule setRunImmediately(Boolean value, SetMode mode) {
        this.putDirect(FIELD_RunImmediately, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public Schedule setRunImmediately(@Nonnull Boolean value) {
        this.putDirect(FIELD_RunImmediately, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public Schedule setRunImmediately(boolean value) {
        this.putDirect(FIELD_RunImmediately, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public Schedule clone() throws CloneNotSupportedException {
        return (Schedule)super.clone();
    }

    public Schedule copy() throws CloneNotSupportedException {
        return (Schedule)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec cronSchedule() {
            return new PathSpec(this.getPathComponents(), "cronSchedule");
        }

        public PathSpec runImmediately() {
            return new PathSpec(this.getPathComponents(), "runImmediately");
        }
    }
}

