/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.type;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gobblin.metadata.types.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeUtils {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeUtils.class);
    private static final ContentTypeUtils INSTANCE = new ContentTypeUtils();
    private ConcurrentHashMap<String, String> knownCharsets = new ConcurrentHashMap();

    public static ContentTypeUtils getInstance() {
        return INSTANCE;
    }

    public String getCharset(String contentType) {
        String charSet = this.knownCharsets.get(contentType);
        if (charSet != null) {
            return charSet;
        }
        if (contentType.startsWith("text/") || contentType.endsWith("+json") || contentType.endsWith("+xml")) {
            return "UTF-8";
        }
        return "BINARY";
    }

    public boolean inferPrintableFromMetadata(Metadata md) {
        String inferredCharset = "BINARY";
        List<String> transferEncoding = md.getGlobalMetadata().getTransferEncoding();
        if (transferEncoding != null) {
            inferredCharset = this.getCharset(transferEncoding.get(transferEncoding.size() - 1));
        } else if (md.getGlobalMetadata().getContentType() != null) {
            inferredCharset = this.getCharset(md.getGlobalMetadata().getContentType());
        }
        return inferredCharset.equals("UTF-8");
    }

    public void registerCharsetMapping(String contentType, String charSet) {
        if (this.knownCharsets.contains(contentType)) {
            log.warn("{} is already registered; re-registering");
        }
        this.knownCharsets.put(contentType, charSet);
    }

    private ContentTypeUtils() {
        this.knownCharsets.put("base64", "UTF-8");
        this.knownCharsets.put("aes_rotating", "UTF-8");
        this.knownCharsets.put("gzip", "BINARY");
        this.knownCharsets.put("application/xml", "UTF-8");
        this.knownCharsets.put("application/json", "UTF-8");
    }
}

