/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.qualitychecker;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.qualitychecker.InstrumentedRowLevelPolicyBase;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;

public class InstrumentedRowLevelPolicyDecorator
extends InstrumentedRowLevelPolicyBase
implements Decorator {
    private RowLevelPolicy embeddedPolicy;
    private boolean isEmbeddedInstrumented;

    public InstrumentedRowLevelPolicyDecorator(RowLevelPolicy policy) {
        super(policy.getTaskState(), policy.getType(), Optional.of(DecoratorUtils.resolveUnderlyingObject((Object)policy).getClass()));
        this.embeddedPolicy = policy;
        this.isEmbeddedInstrumented = Instrumented.isLineageInstrumented(policy);
    }

    @Override
    public MetricContext getMetricContext() {
        return this.isEmbeddedInstrumented ? ((InstrumentedRowLevelPolicyBase)this.embeddedPolicy).getMetricContext() : super.getMetricContext();
    }

    @Override
    public RowLevelPolicy.Result executePolicy(Object record) {
        return this.isEmbeddedInstrumented ? this.executePolicyImpl(record) : super.executePolicy(record);
    }

    @Override
    public RowLevelPolicy.Result executePolicyImpl(Object record) {
        return this.embeddedPolicy.executePolicy(record);
    }

    @Override
    public void close() throws IOException {
        this.embeddedPolicy.close();
    }

    public Object getDecoratedObject() {
        return this.embeddedPolicy;
    }

    public State getFinalState() {
        return this.embeddedPolicy.getFinalState();
    }
}

