/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.JobCommitPolicy;
import org.apache.gobblin.source.extractor.WorkUnitRetryPolicy;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.ExtractFactory;
import org.apache.gobblin.source.workunit.WorkUnit;

public abstract class AbstractSource<S, D>
implements Source<S, D> {
    private final ExtractFactory extractFactory = new ExtractFactory("yyyyMMddHHmmss");

    protected List<WorkUnitState> getPreviousWorkUnitStatesForRetry(SourceState state) {
        WorkUnitRetryPolicy workUnitRetryPolicy;
        if (Iterables.isEmpty((Iterable)state.getPreviousWorkUnitStates())) {
            return ImmutableList.of();
        }
        if (state.contains("workunit.retry.policy")) {
            workUnitRetryPolicy = WorkUnitRetryPolicy.forName(state.getProp("workunit.retry.policy"));
        } else {
            boolean retryFailedWorkUnits = state.getPropAsBoolean("workunit.retry.enabled", true);
            WorkUnitRetryPolicy workUnitRetryPolicy2 = workUnitRetryPolicy = retryFailedWorkUnits ? WorkUnitRetryPolicy.ALWAYS : WorkUnitRetryPolicy.NEVER;
        }
        if (workUnitRetryPolicy == WorkUnitRetryPolicy.NEVER) {
            return ImmutableList.of();
        }
        ArrayList previousWorkUnitStates = Lists.newArrayList();
        for (WorkUnitState workUnitState : state.getPreviousWorkUnitStates()) {
            if (workUnitState.getWorkingState() == WorkUnitState.WorkingState.COMMITTED) continue;
            if (state.getPropAsBoolean("overwrite.configs.in.statestore", false)) {
                WorkUnitState workUnitStateCopy = new WorkUnitState(workUnitState.getWorkunit(), (State)state);
                workUnitStateCopy.addAll((State)workUnitState);
                workUnitStateCopy.overrideWith((State)state);
                previousWorkUnitStates.add(workUnitStateCopy);
                continue;
            }
            previousWorkUnitStates.add(workUnitState);
        }
        if (workUnitRetryPolicy == WorkUnitRetryPolicy.ALWAYS) {
            return previousWorkUnitStates;
        }
        JobCommitPolicy jobCommitPolicy = JobCommitPolicy.forName(state.getProp("job.commit.policy", "full"));
        if (workUnitRetryPolicy == WorkUnitRetryPolicy.ON_COMMIT_ON_PARTIAL_SUCCESS && jobCommitPolicy == JobCommitPolicy.COMMIT_ON_PARTIAL_SUCCESS || workUnitRetryPolicy == WorkUnitRetryPolicy.ON_COMMIT_ON_FULL_SUCCESS && jobCommitPolicy == JobCommitPolicy.COMMIT_ON_FULL_SUCCESS) {
            return previousWorkUnitStates;
        }
        return ImmutableList.of();
    }

    protected List<WorkUnit> getPreviousWorkUnitsForRetry(SourceState state) {
        ArrayList workUnits = Lists.newArrayList();
        for (WorkUnitState workUnitState : this.getPreviousWorkUnitStatesForRetry(state)) {
            workUnits.add(WorkUnit.copyOf((WorkUnit)workUnitState.getWorkunit()));
        }
        return workUnits;
    }

    public Extract createExtract(Extract.TableType type, String namespace, String table) {
        return this.extractFactory.getUniqueExtract(type, namespace, table);
    }
}

