/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.BatchAccumulator;
import org.apache.gobblin.writer.BytesBoundedBatch;
import org.apache.gobblin.writer.RecordMetadata;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequentialBasedBatchAccumulator<D>
extends BatchAccumulator<D> {
    private Deque<BytesBoundedBatch<D>> dq = new LinkedList<BytesBoundedBatch<D>>();
    private IncompleteRecordBatches incomplete = new IncompleteRecordBatches();
    private final long batchSizeLimit;
    private final long memSizeLimit;
    private final double tolerance = 0.95;
    private final long expireInMilliSecond;
    private static final Logger LOG = LoggerFactory.getLogger(SequentialBasedBatchAccumulator.class);
    private final ReentrantLock dqLock = new ReentrantLock();
    private final Condition notEmpty = this.dqLock.newCondition();
    private final Condition notFull = this.dqLock.newCondition();
    private final long capacity;

    public SequentialBasedBatchAccumulator() {
        this(262144L, 1000L, 100L);
    }

    public SequentialBasedBatchAccumulator(Properties properties) {
        Config config = ConfigUtils.propertiesToConfig((Properties)properties);
        this.batchSizeLimit = ConfigUtils.getLong((Config)config, (String)"writer.batch.size", (Long)262144L);
        this.expireInMilliSecond = ConfigUtils.getLong((Config)config, (String)"writer.batch.ttl", (Long)1000L);
        this.capacity = ConfigUtils.getLong((Config)config, (String)"writer.batch.queue.capacity", (Long)100L);
        this.memSizeLimit = (long)(this.tolerance * (double)this.batchSizeLimit);
    }

    public SequentialBasedBatchAccumulator(long batchSizeLimit, long expireInMilliSecond, long capacity) {
        this.batchSizeLimit = batchSizeLimit;
        this.expireInMilliSecond = expireInMilliSecond;
        this.capacity = capacity;
        this.memSizeLimit = (long)(this.tolerance * (double)this.batchSizeLimit);
    }

    public long getNumOfBatches() {
        this.dqLock.lock();
        try {
            long l = this.dq.size();
            return l;
        }
        finally {
            this.dqLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Future<RecordMetadata> enqueue(D record, WriteCallback callback) throws InterruptedException {
        ReentrantLock lock = this.dqLock;
        lock.lock();
        try {
            Future<RecordMetadata> future;
            BytesBoundedBatch<D> last = this.dq.peekLast();
            if (last != null && (future = last.tryAppend(record, callback)) != null) {
                Future<RecordMetadata> future2 = future;
                return future2;
            }
            BytesBoundedBatch<D> batch = new BytesBoundedBatch<D>(this.memSizeLimit, this.expireInMilliSecond);
            LOG.debug("Batch " + batch.getId() + " is generated");
            ListenableFuture future3 = batch.tryAppend(record, callback);
            if (future3 == null) {
                LOG.error("Batch " + batch.getId() + " is marked as complete because it contains a huge record: " + record);
                future3 = Futures.immediateFuture((Object)new RecordMetadata(0L));
                callback.onSuccess(WriteResponse.EMPTY);
                ListenableFuture listenableFuture = future3;
                return listenableFuture;
            }
            while ((long)this.dq.size() >= this.capacity) {
                this.notFull.await();
            }
            this.dq.addLast(batch);
            this.incomplete.add(batch);
            this.notEmpty.signal();
            ListenableFuture listenableFuture = future3;
            return listenableFuture;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Batch<D> getNextAvailableBatch() {
        ReentrantLock lock = this.dqLock;
        try {
            lock.lock();
            if (this.isClosed()) {
                Batch batch = this.dq.poll();
                return batch;
            }
            while (this.dq.size() == 0) {
                LOG.info("ready to sleep because of queue is empty");
                this.notEmpty.await();
                if (!this.isClosed()) continue;
                Batch batch = this.dq.poll();
                return batch;
            }
            if (this.dq.size() > 1) {
                BytesBoundedBatch<D> candidate = this.dq.poll();
                this.notFull.signal();
                LOG.debug("retrieve batch " + candidate.getId());
                BytesBoundedBatch<D> bytesBoundedBatch = candidate;
                return bytesBoundedBatch;
            }
            if (this.dq.size() == 1) {
                if (this.dq.peekFirst().isTTLExpire()) {
                    LOG.info("Batch " + this.dq.peekFirst().getId() + " is expired");
                    BytesBoundedBatch<D> candidate = this.dq.poll();
                    this.notFull.signal();
                    BytesBoundedBatch<D> bytesBoundedBatch = candidate;
                    return bytesBoundedBatch;
                }
                Batch<D> candidate = null;
                return candidate;
            }
            try {
                throw new RuntimeException("Should never get to here");
            }
            catch (InterruptedException e) {
                LOG.error("Wait for next batch is interrupted. " + e.toString());
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    @Override
    public void close() {
        super.close();
        this.dqLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.dqLock.unlock();
        }
    }

    @Override
    public void flush() {
        try {
            ArrayList<Batch> batches = this.incomplete.all();
            LOG.info("flush on {} batches", (Object)batches.size());
            for (Batch batch : batches) {
                batch.await();
            }
        }
        catch (Exception e) {
            LOG.info("Error happens when flushing");
        }
    }

    @Override
    public void deallocate(Batch<D> batch) {
        this.incomplete.remove(batch);
    }

    private static final class IncompleteRecordBatches {
        private final Set<Batch> incomplete = new HashSet<Batch>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Batch batch) {
            Set<Batch> set = this.incomplete;
            synchronized (set) {
                this.incomplete.add(batch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Batch batch) {
            Set<Batch> set = this.incomplete;
            synchronized (set) {
                boolean removed = this.incomplete.remove(batch);
                if (!removed) {
                    throw new IllegalStateException("Remove from the incomplete set failed. This should be impossible.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Batch> all() {
            Set<Batch> set = this.incomplete;
            synchronized (set) {
                return new ArrayList<Batch>(this.incomplete);
            }
        }
    }
}

