/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.http.client.AsyncPool;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.util.List;

@ChannelHandler.Sharable
class ChannelPoolHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<AsyncPool<Channel>> CHANNEL_POOL_ATTR_KEY = AttributeKey.valueOf((String)"ChannelPool");

    ChannelPoolHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
        if (pool != null) {
            RestResponse restResponse = (RestResponse)msg;
            List connectionTokens = restResponse.getHeaderValues("connection");
            if (connectionTokens != null) {
                for (String token : connectionTokens) {
                    if (!"close".equalsIgnoreCase(token)) continue;
                    pool.dispose((Object)ctx.channel());
                    return;
                }
            }
            pool.put((Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
        if (pool != null) {
            pool.dispose((Object)ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
        if (pool != null) {
            pool.dispose((Object)ctx.channel());
        }
    }
}

