/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.http.client.AsyncPool;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;

@ChannelHandler.Sharable
class ChannelPoolStreamHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<AsyncPool<Channel>> CHANNEL_POOL_ATTR_KEY = AttributeKey.valueOf((String)"ChannelPool");
    static final Object CHANNEL_RELEASE_SIGNAL = new Object();
    static final Object CHANNEL_DESTROY_SIGNAL = new Object();

    ChannelPoolStreamHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        AsyncPool pool;
        if (msg == CHANNEL_RELEASE_SIGNAL) {
            AsyncPool pool2 = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
            if (pool2 != null) {
                pool2.put((Object)ctx.channel());
            }
        } else if (msg == CHANNEL_DESTROY_SIGNAL && (pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove()) != null) {
            pool.dispose((Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
        if (pool != null) {
            pool.dispose((Object)ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(CHANNEL_POOL_ATTR_KEY).getAndRemove();
        if (pool != null) {
            pool.dispose((Object)ctx.channel());
        }
    }
}

