/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class RAPClientCodec
extends ChannelDuplexHandler {
    private final RAPRequestEncoder _encoder = new RAPRequestEncoder();
    private final RAPResponseDecoder _decoder = new RAPResponseDecoder();

    RAPClientCodec() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this._decoder.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this._encoder.write(ctx, msg, promise);
    }

    private class RAPResponseDecoder
    extends MessageToMessageDecoder<FullHttpResponse> {
        private RAPResponseDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, FullHttpResponse nettyResponse, List<Object> out) throws Exception {
            if (nettyResponse.decoderResult().isFailure()) {
                ctx.fireExceptionCaught(nettyResponse.decoderResult().cause());
                return;
            }
            RestResponseBuilder builder = new RestResponseBuilder();
            builder.setStatus(nettyResponse.status().code());
            for (Map.Entry e : nettyResponse.headers()) {
                if (((String)e.getKey()).equalsIgnoreCase("Set-Cookie")) {
                    builder.addCookie((String)e.getValue());
                    continue;
                }
                builder.unsafeAddHeaderValue((String)e.getKey(), (String)e.getValue());
            }
            ByteBuf buf = nettyResponse.content();
            ByteString entity = ByteString.read((InputStream)new ByteBufInputStream(buf), (int)buf.readableBytes());
            builder.setEntity(entity);
            out.add(builder.build());
        }
    }

    private class RAPRequestEncoder
    extends MessageToMessageEncoder<RestRequest> {
        private RAPRequestEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RestRequest request, List<Object> out) throws Exception {
            HttpMethod nettyMethod = HttpMethod.valueOf((String)request.getMethod());
            URL url = new URL(request.getURI().toString());
            String path = url.getFile();
            if (path.isEmpty()) {
                path = "/";
            }
            ByteString entity = request.getEntity();
            ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)entity.asByteBuffer());
            DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, nettyMethod, path, content);
            for (Map.Entry e : request.getHeaders().entrySet()) {
                nettyRequest.headers().set((String)e.getKey(), e.getValue());
            }
            nettyRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)url.getAuthority());
            nettyRequest.headers().set("Cookie", (Iterable)request.getCookies());
            nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)entity.length());
            out.add(nettyRequest);
        }
    }
}

