/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import java.io.IOException;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.avro.AvroToJsonStringConverter;
import org.apache.gobblin.converter.avro.AvroToJsonStringConverterBase;
import org.apache.gobblin.metadata.types.Metadata;
import org.apache.gobblin.type.RecordWithMetadata;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class AvroToJsonRecordWithMetadataConverter
extends Converter<Schema, String, GenericRecord, RecordWithMetadata<JsonNode>> {
    private Metadata defaultMetadata;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private AvroToJsonStringConverterBase innerConverter = new AvroToJsonStringConverter();

    public String convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.defaultMetadata = new Metadata();
        this.defaultMetadata.getGlobalMetadata().setContentType(inputSchema.getFullName() + "+json");
        return this.innerConverter.convertSchema(inputSchema, workUnit);
    }

    public Iterable<RecordWithMetadata<JsonNode>> convertRecord(String outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            Iterable innerRecordIterable = this.innerConverter.convertRecord(outputSchema, inputRecord, workUnit);
            String record = (String)innerRecordIterable.iterator().next();
            JsonNode jsonRoot = (JsonNode)objectMapper.readValue(record, JsonNode.class);
            return Collections.singleton(new RecordWithMetadata((Object)jsonRoot, this.defaultMetadata));
        }
        catch (IOException e) {
            throw new DataConversionException("Error converting to JSON", (Throwable)e);
        }
    }
}

