/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.SharedResourcesBrokerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings
public class TTLResourceEntry<T>
extends ResourceInstance<T> {
    private static final Logger log = LoggerFactory.getLogger(TTLResourceEntry.class);
    private final long expireAt;
    private final boolean closeOnInvalidation;

    public TTLResourceEntry(T resource, long millisToLive, boolean closeOnInvalidation) {
        super(resource);
        this.expireAt = System.currentTimeMillis() + millisToLive;
        this.closeOnInvalidation = closeOnInvalidation;
    }

    @Override
    public boolean isValid() {
        return System.currentTimeMillis() < this.expireAt;
    }

    @Override
    public void onInvalidate() {
        if (this.closeOnInvalidation) {
            SharedResourcesBrokerUtils.shutdownObject(this.getResource(), log);
        }
    }
}

