/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortUtils {
    public static final int MINIMUM_PORT = 1025;
    public static final int MAXIMUM_PORT = 65535;
    private static final Pattern PORT_REGEX = Pattern.compile("\\$\\{PORT_(?>(?>\\?(\\d+))|(?>(\\d+)\\?)|(\\d+|\\?))\\}");
    private final PortLocator portLocator;
    private final ConcurrentMap<Integer, Boolean> assignedPorts;

    public PortUtils() {
        this(new ServerSocketPortLocator());
    }

    @VisibleForTesting
    PortUtils(PortLocator locator) {
        this.portLocator = locator;
        this.assignedPorts = Maps.newConcurrentMap();
    }

    public String replacePortTokens(String value) {
        HashBiMap portMappings = HashBiMap.create();
        Matcher regexMatcher = PORT_REGEX.matcher(value);
        while (regexMatcher.find()) {
            String token = regexMatcher.group(0);
            if (portMappings.containsKey((Object)token)) continue;
            Optional portStart = Optional.absent();
            Optional portEnd = Optional.absent();
            String unboundedStart = regexMatcher.group(1);
            if (unboundedStart != null) {
                int requestedEndPort = Integer.parseInt(unboundedStart);
                Preconditions.checkArgument((requestedEndPort <= 65535 ? 1 : 0) != 0);
                portEnd = Optional.of((Object)requestedEndPort);
            } else {
                String unboundedEnd = regexMatcher.group(2);
                if (unboundedEnd != null) {
                    int requestedStartPort = Integer.parseInt(unboundedEnd);
                    Preconditions.checkArgument((requestedStartPort >= 1025 ? 1 : 0) != 0);
                    portStart = Optional.of((Object)requestedStartPort);
                } else {
                    String absolute = regexMatcher.group(3);
                    if (!"?".equals(absolute)) {
                        int requestedPort = Integer.parseInt(absolute);
                        Preconditions.checkArgument((requestedPort >= 1025 && requestedPort <= 65535 ? 1 : 0) != 0);
                        portStart = Optional.of((Object)requestedPort);
                        portEnd = Optional.of((Object)requestedPort);
                    }
                }
            }
            Optional<Integer> port = this.takePort((Optional<Integer>)portStart, (Optional<Integer>)portEnd);
            portMappings.put((Object)token, port);
        }
        for (Map.Entry port : portMappings.entrySet()) {
            if (!((Optional)port.getValue()).isPresent()) continue;
            value = value.replace((CharSequence)port.getKey(), ((Integer)((Optional)port.getValue()).get()).toString());
        }
        return value;
    }

    private synchronized Optional<Integer> takePort(Optional<Integer> portStart, Optional<Integer> portEnd) {
        if (!portStart.isPresent() && !portEnd.isPresent()) {
            for (int i = 0; i < 65535; ++i) {
                try {
                    int port = this.portLocator.random();
                    Boolean wasAssigned = this.assignedPorts.putIfAbsent(port, true);
                    if (wasAssigned == null || !wasAssigned.booleanValue()) {
                        return Optional.of((Object)port);
                    }
                    continue;
                }
                catch (Exception port) {
                    // empty catch block
                }
            }
        }
        for (int port = ((Integer)portStart.or((Object)1025)).intValue(); port <= (Integer)portEnd.or((Object)65535); ++port) {
            try {
                this.portLocator.specific(port);
                Boolean wasAssigned = this.assignedPorts.putIfAbsent(port, true);
                if (wasAssigned != null && wasAssigned.booleanValue()) continue;
                return Optional.of((Object)port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException(String.format("No open port could be found for %s to %s", portStart, portEnd));
    }

    private static class ServerSocketPortLocator
    implements PortLocator {
        private ServerSocketPortLocator() {
        }

        @Override
        public int random() throws Exception {
            try (ServerSocket serverSocket = new ServerSocket(0);){
                int n = serverSocket.getLocalPort();
                return n;
            }
        }

        @Override
        public int specific(int port) throws Exception {
            try (ServerSocket serverSocket = new ServerSocket(port);){
                int n = serverSocket.getLocalPort();
                return n;
            }
        }
    }

    @VisibleForTesting
    static interface PortLocator {
        public int random() throws Exception;

        public int specific(int var1) throws Exception;
    }
}

