/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.executors.ForceQueuePolicy;
import org.apache.gobblin.util.executors.ScalingQueue;

public class ScalingThreadPoolExecutor
extends ThreadPoolExecutor {
    public static ScalingThreadPoolExecutor newScalingThreadPool(int min, int max, long keepAliveTime) {
        return ScalingThreadPoolExecutor.newScalingThreadPool(min, max, keepAliveTime, Executors.defaultThreadFactory());
    }

    public static ScalingThreadPoolExecutor newScalingThreadPool(int min, int max, long keepAliveTime, ThreadFactory threadFactory) {
        ScalingQueue queue = new ScalingQueue();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue, threadFactory);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    private ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }
}

