/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.gobblin.password.PasswordManager;

public class DataSourceProvider
implements Provider<DataSource> {
    public static final String GOBBLIN_UTIL_JDBC_PREFIX = "gobblin.util.jdbc.";
    public static final String CONN_DRIVER = "gobblin.util.jdbc.conn.driver";
    public static final String CONN_URL = "gobblin.util.jdbc.conn.url";
    public static final String USERNAME = "gobblin.util.jdbc.username";
    public static final String PASSWORD = "gobblin.util.jdbc.password";
    public static final String MAX_IDLE_CONNS = "gobblin.util.jdbc.max.idle.connections";
    public static final String MAX_ACTIVE_CONNS = "gobblin.util.jdbc.max.active.connections";
    public static final String DEFAULT_CONN_DRIVER = "com.mysql.jdbc.Driver";
    protected final BasicDataSource basicDataSource = new BasicDataSource();

    @Inject
    public DataSourceProvider(@Named(value="dataSourceProperties") Properties properties) {
        this.basicDataSource.setDriverClassName(properties.getProperty(CONN_DRIVER, DEFAULT_CONN_DRIVER));
        this.basicDataSource.setUrl(properties.getProperty(CONN_URL));
        if (properties.containsKey(USERNAME) && properties.containsKey(PASSWORD)) {
            this.basicDataSource.setUsername(properties.getProperty(USERNAME));
            this.basicDataSource.setPassword(PasswordManager.getInstance((Properties)properties).readPassword(properties.getProperty(PASSWORD)));
        }
        if (properties.containsKey(MAX_IDLE_CONNS)) {
            this.basicDataSource.setMaxIdle(Integer.parseInt(properties.getProperty(MAX_IDLE_CONNS)));
        }
        if (properties.containsKey(MAX_ACTIVE_CONNS)) {
            this.basicDataSource.setMaxActive(Integer.parseInt(properties.getProperty(MAX_ACTIVE_CONNS)));
        }
    }

    public DataSourceProvider() {
    }

    public DataSource get() {
        return this.basicDataSource;
    }
}

