/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinConstructorUtils {
    private static final Logger log = LoggerFactory.getLogger(GobblinConstructorUtils.class);

    @SafeVarargs
    public static <T> T invokeFirstConstructor(Class<T> cls, List<Object> ... constructorArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        for (List<Object> args : constructorArgs) {
            Class[] parameterTypes = new Class[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                parameterTypes[i] = args.get(i).getClass();
            }
            if (ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])parameterTypes) == null) continue;
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args.toArray(new Object[args.size()]));
        }
        throw new NoSuchMethodException("No accessible constructor found");
    }

    public static <T> T invokeLongestConstructor(Class<T> cls, Object ... args) throws ReflectiveOperationException {
        int i;
        Object[] parameterTypes = new Class[args.length];
        for (i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        for (i = args.length; i >= 0; --i) {
            if (ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])Arrays.copyOfRange(parameterTypes, 0, i)) == null) continue;
            log.debug(String.format("Found accessible constructor for class %s with parameter types %s.", cls, Arrays.toString(Arrays.copyOfRange(parameterTypes, 0, i))));
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])Arrays.copyOfRange(args, 0, i));
        }
        throw new NoSuchMethodException(String.format("No accessible constructor for class %s with parameters a subset of %s.", cls, Arrays.toString(parameterTypes)));
    }

    public static <T> T invokeConstructor(Class<T> superType, String clsName, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(Class.forName(clsName), (Object[])args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

