/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;

public class BytesToAvroConverter
extends Converter<String, Schema, byte[], GenericRecord> {
    private Schema latestSchema = null;
    private GenericDatumReader<GenericRecord> recordReader = null;
    private ThreadLocal<BinaryDecoder> decoderCache = new ThreadLocal<BinaryDecoder>(){

        @Override
        protected BinaryDecoder initialValue() {
            return null;
        }
    };

    public Schema convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.latestSchema = new Schema.Parser().parse(inputSchema);
        this.recordReader = new GenericDatumReader(this.latestSchema);
        return this.latestSchema;
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, byte[] inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Preconditions.checkNotNull(this.recordReader, (Object)"Must have called convertSchema!");
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputRecord, this.decoderCache.get());
        try {
            GenericRecord parsedRecord = (GenericRecord)this.recordReader.read(null, (Decoder)decoder);
            this.decoderCache.set(decoder);
            return Collections.singleton(parsedRecord);
        }
        catch (IOException e) {
            throw new DataConversionException("Error parsing record", (Throwable)e);
        }
    }
}

