/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.source.extractor.schema.Schema;

public class JsonSchema
extends Schema {
    public static final String RECORD_FIELDS_KEY = "values";
    public static final String TYPE_KEY = "type";
    public static final String NAME_KEY = "name";
    public static final String SIZE_KEY = "size";
    public static final String ENUM_SYMBOLS_KEY = "symbols";
    public static final String COLUMN_NAME_KEY = "columnName";
    public static final String DATA_TYPE_KEY = "dataType";
    public static final String COMMENT_KEY = "comment";
    public static final String DEFAULT_VALUE_KEY = "defaultValue";
    public static final String IS_NULLABLE_KEY = "isNullable";
    public static final String DEFAULT_RECORD_COLUMN_NAME = "root";
    public static final String DEFAULT_VALUE_FOR_OPTIONAL_PROPERTY = "";
    public static final String ARRAY_ITEMS_KEY = "items";
    public static final String MAP_ITEMS_KEY = "values";
    public static final String SOURCE_TYPE = "source.type";
    private final JsonElementConversionFactory.Type type;
    private final JsonObject json;
    private final SchemaType schemaNestedLevel;
    private JsonSchema secondType;
    private JsonSchema firstType;
    private JsonArray jsonArray;

    public JsonSchema(JsonArray jsonArray) {
        JsonObject jsonObject = new JsonObject();
        JsonObject dataType = new JsonObject();
        jsonObject.addProperty(COLUMN_NAME_KEY, DEFAULT_RECORD_COLUMN_NAME);
        dataType.addProperty(TYPE_KEY, JsonElementConversionFactory.Type.RECORD.toString());
        dataType.add("values", (JsonElement)jsonArray);
        jsonObject.add(DATA_TYPE_KEY, (JsonElement)dataType);
        this.setJsonSchemaProperties(jsonObject);
        this.type = JsonElementConversionFactory.Type.RECORD;
        this.json = jsonObject;
        this.jsonArray = jsonArray;
        this.schemaNestedLevel = SchemaType.ROOT;
    }

    public JsonSchema(JsonObject jsonObject) {
        JsonArray jsonArray;
        JsonObject root = new JsonObject();
        if (!jsonObject.has(COLUMN_NAME_KEY) && !jsonObject.has(DATA_TYPE_KEY)) {
            root.addProperty(COLUMN_NAME_KEY, DEFAULT_RECORD_COLUMN_NAME);
            root.add(DATA_TYPE_KEY, (JsonElement)jsonObject);
            jsonObject = root;
        }
        if (!jsonObject.has(COLUMN_NAME_KEY) && jsonObject.has(DATA_TYPE_KEY)) {
            jsonObject.addProperty(COLUMN_NAME_KEY, DEFAULT_RECORD_COLUMN_NAME);
        }
        this.setJsonSchemaProperties(jsonObject);
        JsonElement typeElement = this.getDataType().get(TYPE_KEY);
        if (typeElement.isJsonPrimitive()) {
            this.type = JsonElementConversionFactory.Type.valueOf(typeElement.getAsString().toUpperCase());
        } else if (typeElement.isJsonArray()) {
            jsonArray = typeElement.getAsJsonArray();
            if (jsonArray.size() != 2) {
                throw new RuntimeException("Invalid typeproperty in schema for union types");
            }
            this.type = JsonElementConversionFactory.Type.UNION;
            JsonElement type1 = jsonArray.get(0);
            JsonElement type2 = jsonArray.get(1);
            if (type1.isJsonPrimitive()) {
                this.firstType = JsonSchema.buildBaseSchema(JsonElementConversionFactory.Type.valueOf(type1.getAsString().toUpperCase()));
            }
            if (type2.isJsonPrimitive()) {
                this.secondType = JsonSchema.buildBaseSchema(JsonElementConversionFactory.Type.valueOf(type2.getAsString().toUpperCase()));
            }
            if (type1.isJsonObject()) {
                this.firstType = JsonSchema.buildBaseSchema(type1.getAsJsonObject());
            }
            if (type2.isJsonObject()) {
                this.secondType = JsonSchema.buildBaseSchema(type2.getAsJsonObject());
            }
        } else {
            throw new RuntimeException("Invalid typeproperty in schema");
        }
        this.json = jsonObject;
        jsonArray = new JsonArray();
        jsonArray.add((JsonElement)jsonObject);
        this.jsonArray = jsonArray;
        this.schemaNestedLevel = SchemaType.CHILD;
    }

    public JsonArray getSymbols() {
        if (this.type.equals((Object)JsonElementConversionFactory.Type.ENUM)) {
            return this.getDataType().get(ENUM_SYMBOLS_KEY).getAsJsonArray();
        }
        return new JsonArray();
    }

    public JsonElementConversionFactory.Type getType() {
        return this.type;
    }

    public static JsonSchema buildBaseSchema(JsonElementConversionFactory.Type type) {
        JsonObject jsonObject = new JsonObject();
        JsonObject dataType = new JsonObject();
        jsonObject.addProperty(COLUMN_NAME_KEY, DEFAULT_RECORD_COLUMN_NAME);
        dataType.addProperty(TYPE_KEY, type.toString());
        jsonObject.add(DATA_TYPE_KEY, (JsonElement)dataType);
        return new JsonSchema(jsonObject);
    }

    public static JsonSchema buildBaseSchema(JsonObject root) {
        root.addProperty(COLUMN_NAME_KEY, DEFAULT_RECORD_COLUMN_NAME);
        return new JsonSchema(root);
    }

    public static String getOptionalProperty(JsonObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.get(key).getAsString() : DEFAULT_VALUE_FOR_OPTIONAL_PROPERTY;
    }

    public JsonSchema getValuesWithinDataType() {
        JsonElement element = this.getDataType().get("values");
        if (element.isJsonObject()) {
            return new JsonSchema(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return new JsonSchema(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return JsonSchema.buildBaseSchema(JsonElementConversionFactory.Type.valueOf(element.getAsString().toUpperCase()));
        }
        throw new UnsupportedOperationException("Map values can only be defined using JsonObject, JsonArray or JsonPrimitive.");
    }

    public int getSizeOfFixedData() {
        if (this.type.equals((Object)JsonElementConversionFactory.Type.FIXED)) {
            return this.getDataType().get(SIZE_KEY).getAsInt();
        }
        return 0;
    }

    public boolean isType(JsonElementConversionFactory.Type type) {
        return this.type.equals((Object)type);
    }

    public JsonElementConversionFactory.Type getTypeOfArrayItems() throws DataConversionException {
        JsonSchema arrayValues = this.getItemsWithinDataType();
        if (arrayValues == null) {
            throw new DataConversionException("Array types only allow values as primitive, null or JsonObject");
        }
        return arrayValues.getType();
    }

    public JsonSchema getItemsWithinDataType() {
        JsonElement element = this.getDataType().get(ARRAY_ITEMS_KEY);
        if (element.isJsonObject()) {
            return new JsonSchema(element.getAsJsonObject());
        }
        if (element.isJsonPrimitive()) {
            return JsonSchema.buildBaseSchema(JsonElementConversionFactory.Type.valueOf(element.getAsString().toUpperCase()));
        }
        throw new UnsupportedOperationException("Array items can only be defined using JsonObject or JsonPrimitive.");
    }

    public JsonSchema getFirstTypeSchema() {
        return this.firstType;
    }

    public JsonSchema getSecondTypeSchema() {
        return this.secondType;
    }

    public int fieldsCount() {
        return this.jsonArray.size();
    }

    public JsonSchema getFieldSchemaAt(int i) {
        if (i >= this.jsonArray.size()) {
            return new JsonSchema(this.json);
        }
        return new JsonSchema(this.jsonArray.get(i).getAsJsonObject());
    }

    public List<JsonSchema> getDataTypes() {
        if (this.firstType != null && this.secondType != null) {
            return Arrays.asList(this.firstType, this.secondType);
        }
        return Collections.singletonList(this);
    }

    public boolean isRoot() {
        return this.schemaNestedLevel.equals((Object)SchemaType.ROOT);
    }

    public String getName() {
        return JsonSchema.getOptionalProperty(this.getDataType(), NAME_KEY);
    }

    private void setJsonSchemaProperties(JsonObject jsonObject) {
        this.setColumnName(jsonObject.get(COLUMN_NAME_KEY).getAsString());
        this.setDataType(jsonObject.get(DATA_TYPE_KEY).getAsJsonObject());
        this.setNullable(jsonObject.has(IS_NULLABLE_KEY) && jsonObject.get(IS_NULLABLE_KEY).getAsBoolean());
        this.setComment(JsonSchema.getOptionalProperty(jsonObject, COMMENT_KEY));
        this.setDefaultValue(JsonSchema.getOptionalProperty(jsonObject, DEFAULT_VALUE_KEY));
    }

    public static enum SchemaType {
        ROOT,
        CHILD;

    }
}

