/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.filebased;

import com.google.common.base.Preconditions;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.filebased.FileBasedExtractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelper;
import org.apache.gobblin.source.extractor.filebased.TokenizedFileDownloader;

public class TokenBasedFileInputStreamExtractor
extends FileBasedExtractor<String, String> {
    public static final String TOKEN = "gobblin.extractor." + TokenBasedFileInputStreamExtractor.class.getSimpleName() + ".token";
    public static final String CHARSET = "gobblin.extractor." + TokenBasedFileInputStreamExtractor.class.getSimpleName() + ".charSet";
    private final String token;
    private final String charSet;

    public TokenBasedFileInputStreamExtractor(WorkUnitState workUnitState, FileBasedHelper fsHelper) {
        super(workUnitState, fsHelper);
        Preconditions.checkArgument((boolean)(this.fileDownloader instanceof TokenizedFileDownloader));
        this.token = workUnitState.getProp(TOKEN, "\n");
        this.charSet = workUnitState.getProp(CHARSET, ConfigurationKeys.DEFAULT_CHARSET_ENCODING.name());
        ((TokenizedFileDownloader)this.fileDownloader).setToken(this.token);
        ((TokenizedFileDownloader)this.fileDownloader).setCharset(this.charSet);
    }
}

