/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.github.rholder.retry.RetryerBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.records.ControlMessageHandler;
import org.apache.gobblin.records.FlushControlMessageHandler;
import org.apache.gobblin.stream.ControlMessage;
import org.apache.gobblin.stream.FlushControlMessage;
import org.apache.gobblin.stream.MetadataUpdateControlMessage;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.FinalState;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.Retriable;
import org.apache.gobblin.writer.RetryWriter;
import org.apache.gobblin.writer.WriterWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseOnFlushWriterWrapper<D>
extends WriterWrapper<D>
implements Decorator,
FinalState,
Retriable {
    public static final String WRITER_CLOSE_ON_FLUSH_KEY = "writer.closeOnFlush";
    public static final boolean DEFAULT_WRITER_CLOSE_ON_FLUSH = false;
    public static final String WRITER_CLOSE_ON_METADATA_UPDATE = "writer.closeOnMetadataUpdate";
    public static final boolean DEFAULT_CLOSE_ON_METADATA_UPDATE = true;
    private static final Logger LOG = LoggerFactory.getLogger(CloseOnFlushWriterWrapper.class);
    private final State state;
    private DataWriter<D> writer;
    private final Supplier<DataWriter<D>> writerSupplier;
    private boolean closed;
    private final boolean closeOnFlush;
    private final ControlMessageHandler controlMessageHandler;
    private final boolean closeOnMetadataUpdate;

    public CloseOnFlushWriterWrapper(Supplier<DataWriter<D>> writerSupplier, State state) {
        Preconditions.checkNotNull((Object)state, (Object)"State is required.");
        this.state = state;
        this.writerSupplier = writerSupplier;
        this.writer = writerSupplier.get();
        this.closed = false;
        this.closeOnFlush = this.state.getPropAsBoolean(WRITER_CLOSE_ON_FLUSH_KEY, false);
        this.controlMessageHandler = new CloseOnFlushWriterMessageHandler();
        this.closeOnMetadataUpdate = this.state.getPropAsBoolean(WRITER_CLOSE_ON_METADATA_UPDATE, true);
    }

    public Object getDecoratedObject() {
        return this.writer;
    }

    public void writeEnvelope(RecordEnvelope<D> record) throws IOException {
        if (this.closed) {
            this.writer = this.writerSupplier.get();
            this.closed = false;
        }
        this.writer.writeEnvelope(record);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.writer.close();
            this.closed = true;
        }
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    public void cleanup() throws IOException {
        this.writer.cleanup();
    }

    public long recordsWritten() {
        return this.writer.recordsWritten();
    }

    public long bytesWritten() throws IOException {
        return this.writer.bytesWritten();
    }

    @Override
    public RetryerBuilder<Void> getRetryerBuilder() {
        if (this.writer instanceof Retriable) {
            return ((Retriable)this.writer).getRetryerBuilder();
        }
        return RetryWriter.createRetryBuilder(this.state);
    }

    public State getFinalState() {
        State state = new State();
        if (this.writer instanceof FinalState) {
            state.addAll(((FinalState)this.writer).getFinalState());
        } else {
            LOG.warn("Wrapped writer does not implement FinalState: " + this.writer.getClass());
        }
        return state;
    }

    public ControlMessageHandler getMessageHandler() {
        return this.controlMessageHandler;
    }

    public void flush() throws IOException {
        this.flush(this.closeOnFlush);
    }

    private void flush(boolean close) throws IOException {
        this.writer.flush();
        if (close) {
            this.commit();
            this.close();
        }
    }

    private class CloseOnFlushWriterMessageHandler
    implements ControlMessageHandler {
        private CloseOnFlushWriterMessageHandler() {
        }

        public void handleMessage(ControlMessage message) {
            ControlMessageHandler underlyingHandler = CloseOnFlushWriterWrapper.this.writer.getMessageHandler();
            underlyingHandler.handleMessage(message);
            if (message instanceof FlushControlMessage && (CloseOnFlushWriterWrapper.this.closeOnFlush || ((FlushControlMessage)message).getFlushType() == FlushControlMessage.FlushType.FLUSH_AND_CLOSE) || message instanceof MetadataUpdateControlMessage && CloseOnFlushWriterWrapper.this.closeOnMetadataUpdate) {
                try {
                    if (underlyingHandler instanceof FlushControlMessageHandler) {
                        CloseOnFlushWriterWrapper.this.commit();
                        CloseOnFlushWriterWrapper.this.close();
                    } else {
                        CloseOnFlushWriterWrapper.this.flush(true);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not flush when handling FlushControlMessage", e);
                }
            }
        }
    }
}

