/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.gobblin.converter.http.RestEntry;
import org.apache.gobblin.exception.NonTransientException;
import org.apache.gobblin.writer.http.RestJsonWriter;
import org.apache.gobblin.writer.http.SalesForceRestWriterBuilder;
import org.apache.gobblin.writer.http.UnexpectedResponseException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class SalesforceRestWriter
extends RestJsonWriter {
    static final String DUPLICATE_VALUE_ERR_CODE = "DUPLICATE_VALUE";
    private String accessToken;
    private final URI oauthEndPoint;
    private final String clientId;
    private final String clientSecret;
    private final String userId;
    private final String password;
    private final String securityToken;
    private final Operation operation;
    private final int batchSize;
    private final Optional<String> batchResourcePath;
    private Optional<JsonArray> batchRecords = Optional.absent();
    private long numRecordsWritten = 0L;

    public SalesforceRestWriter(SalesForceRestWriterBuilder builder) {
        super(builder);
        this.oauthEndPoint = (URI)builder.getSvcEndpoint().get();
        this.clientId = builder.getClientId();
        this.clientSecret = builder.getClientSecret();
        this.userId = builder.getUserId();
        this.password = builder.getPassword();
        this.securityToken = builder.getSecurityToken();
        this.operation = builder.getOperation();
        this.batchSize = builder.getBatchSize();
        this.batchResourcePath = builder.getBatchResourcePath();
        Preconditions.checkArgument((this.batchSize == 1 || this.batchResourcePath.isPresent() ? 1 : 0) != 0, (Object)"Batch resource path is missing");
        if (this.batchSize > 1) {
            this.getLog().info("Batch api will be used with batch size " + this.batchSize);
        }
        try {
            this.onConnect(this.oauthEndPoint);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    SalesforceRestWriter(SalesForceRestWriterBuilder builder, String accessToken) {
        super(builder);
        this.oauthEndPoint = (URI)builder.getSvcEndpoint().get();
        this.clientId = builder.getClientId();
        this.clientSecret = builder.getClientSecret();
        this.userId = builder.getUserId();
        this.password = builder.getPassword();
        this.securityToken = builder.getSecurityToken();
        this.operation = builder.getOperation();
        this.batchSize = builder.getBatchSize();
        this.batchResourcePath = builder.getBatchResourcePath();
        Preconditions.checkArgument((this.batchSize == 1 || this.batchResourcePath.isPresent() ? 1 : 0) != 0, (Object)"Batch resource path is missing");
        this.accessToken = accessToken;
    }

    @Override
    public void onConnect(URI serverHost) throws IOException {
        if (!StringUtils.isEmpty((CharSequence)this.accessToken)) {
            return;
        }
        try {
            this.getLog().info("Getting Oauth2 access token.");
            OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)serverHost.toString()).setGrantType(GrantType.PASSWORD).setClientId(this.clientId).setClientSecret(this.clientSecret).setUsername(this.userId).setPassword(this.password + this.securityToken).buildQueryMessage();
            OAuthClient client = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthJSONAccessTokenResponse response = client.accessToken(request, "POST");
            this.accessToken = response.getAccessToken();
            this.setCurServerHost(new URI(response.getParam("instance_url")));
        }
        catch (OAuthProblemException e) {
            throw new NonTransientException("Error while authenticating with Oauth2", (Throwable)e);
        }
        catch (OAuthSystemException e) {
            throw new RuntimeException("Failed getting access token", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed due to invalid instance url", e);
        }
    }

    @Override
    public Optional<HttpUriRequest> onNewRecord(RestEntry<JsonObject> record) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.accessToken) ? 1 : 0) != 0, (Object)"Access token has not been acquired.");
        Preconditions.checkNotNull(record, (Object)"Record should not be null");
        RequestBuilder builder = null;
        JsonObject payload = null;
        if (this.batchSize > 1) {
            if (!this.batchRecords.isPresent()) {
                this.batchRecords = Optional.of((Object)new JsonArray());
            }
            ((JsonArray)this.batchRecords.get()).add((JsonElement)this.newSubrequest(record));
            if (((JsonArray)this.batchRecords.get()).size() < this.batchSize) {
                return Optional.absent();
            }
            payload = this.newPayloadForBatch();
            builder = RequestBuilder.post().setUri(this.combineUrl(this.getCurServerHost(), this.batchResourcePath));
        } else {
            switch (this.operation) {
                case INSERT_ONLY_NOT_EXIST: {
                    builder = RequestBuilder.post();
                    break;
                }
                case UPSERT: {
                    builder = RequestBuilder.patch();
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.operation) + " is not supported.");
                }
            }
            builder.setUri(this.combineUrl(this.getCurServerHost(), record.getResourcePath()));
            payload = record.getRestEntryVal();
        }
        return Optional.of((Object)this.newRequest(builder, (JsonElement)payload));
    }

    private JsonObject newSubrequest(RestEntry<JsonObject> record) {
        Preconditions.checkArgument((boolean)record.getResourcePath().isPresent(), (Object)"Resource path is not defined");
        JsonObject subReq = new JsonObject();
        subReq.addProperty("url", (String)record.getResourcePath().get());
        subReq.add("richInput", (JsonElement)record.getRestEntryVal());
        switch (this.operation) {
            case INSERT_ONLY_NOT_EXIST: {
                subReq.addProperty("method", "POST");
                break;
            }
            case UPSERT: {
                subReq.addProperty("method", "PATCH");
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)this.operation) + " is not supported.");
            }
        }
        return subReq;
    }

    private JsonObject newPayloadForBatch() {
        JsonObject payload = new JsonObject();
        payload.add("batchRequests", (JsonElement)this.batchRecords.get());
        return payload;
    }

    private HttpUriRequest newRequest(RequestBuilder builder, JsonElement payload) {
        try {
            builder.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).addHeader("Authorization", "OAuth " + this.accessToken).setEntity((HttpEntity)new StringEntity(payload.toString(), ContentType.APPLICATION_JSON));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Request builder: " + ToStringBuilder.reflectionToString((Object)builder, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
        return builder.build();
    }

    @Override
    public void flush() {
        try {
            if (this.isRetry()) {
                super.writeImpl(null);
                return;
            }
            if (this.batchRecords.isPresent() && ((JsonArray)this.batchRecords.get()).size() > 0) {
                this.getLog().info("Flusing remaining subrequest of batch. # of subrequests: " + ((JsonArray)this.batchRecords.get()).size());
                this.curRequest = Optional.of((Object)this.newRequest(RequestBuilder.post().setUri(this.combineUrl(this.getCurServerHost(), this.batchResourcePath)), (JsonElement)this.newPayloadForBatch()));
                super.writeImpl(null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processResponse(CloseableHttpResponse response) throws IOException, UnexpectedResponseException {
        int statusCode;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Received response " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
        if ((statusCode = response.getStatusLine().getStatusCode()) == 401 || statusCode == 403) {
            this.getLog().info("Reacquiring access token.");
            this.accessToken = null;
            this.onConnect(this.oauthEndPoint);
            throw new RuntimeException("Access denied. Access token has been reacquired and retry may solve the problem. " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
        if (this.batchSize > 1) {
            this.processBatchRequestResponse(response);
            this.numRecordsWritten += (long)((JsonArray)this.batchRecords.get()).size();
            this.batchRecords = Optional.absent();
        } else {
            this.processSingleRequestResponse(response);
            ++this.numRecordsWritten;
        }
    }

    private void processSingleRequestResponse(CloseableHttpResponse response) throws IOException, UnexpectedResponseException {
        JsonArray jsonArray;
        JsonObject jsonObject;
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 400) {
            return;
        }
        String entityStr = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 400 && Operation.INSERT_ONLY_NOT_EXIST.equals((Object)this.operation) && entityStr != null && this.isDuplicate(jsonObject = (jsonArray = new JsonParser().parse(entityStr).getAsJsonArray()).get(0).getAsJsonObject(), statusCode)) {
            return;
        }
        throw new RuntimeException("Failed due to " + entityStr + " (Detail: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE) + " )");
    }

    private void processBatchRequestResponse(CloseableHttpResponse response) throws IOException, UnexpectedResponseException {
        String entityStr = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            throw new RuntimeException("Failed due to " + entityStr + " (Detail: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE) + " )");
        }
        JsonObject jsonBody = new JsonParser().parse(entityStr).getAsJsonObject();
        if (!jsonBody.get("hasErrors").getAsBoolean()) {
            return;
        }
        JsonArray results = jsonBody.get("results").getAsJsonArray();
        for (JsonElement jsonElem : results) {
            JsonObject json = jsonElem.getAsJsonObject();
            int subStatusCode = json.get("statusCode").getAsInt();
            if (subStatusCode < 400) continue;
            if (subStatusCode == 400 && Operation.INSERT_ONLY_NOT_EXIST.equals((Object)this.operation)) {
                JsonElement resultJsonElem = json.get("result");
                Preconditions.checkNotNull((Object)resultJsonElem, (Object)"Error response should contain result property");
                JsonObject resultJsonObject = resultJsonElem.getAsJsonArray().get(0).getAsJsonObject();
                if (this.isDuplicate(resultJsonObject, subStatusCode)) continue;
            }
            throw new RuntimeException("Failed due to " + jsonBody + " (Detail: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE) + " )");
        }
    }

    private boolean isDuplicate(JsonObject responseJsonObject, int statusCode) {
        return statusCode == 400 && Operation.INSERT_ONLY_NOT_EXIST.equals((Object)this.operation) && DUPLICATE_VALUE_ERR_CODE.equals(responseJsonObject.get("errorCode").getAsString());
    }

    @Override
    public long recordsWritten() {
        return this.numRecordsWritten;
    }

    public static enum Operation {
        INSERT_ONLY_NOT_EXIST,
        UPSERT;

    }
}

