/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cli;

import com.google.common.base.Optional;
import com.google.common.io.Closer;
import com.linkedin.r2.RemoteInvocationException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobExecutionInfoClient;
import org.apache.gobblin.rest.JobExecutionQuery;
import org.apache.gobblin.rest.JobExecutionQueryResult;
import org.apache.gobblin.rest.QueryIdTypeEnum;
import org.apache.gobblin.rest.QueryListType;

public class AdminClient {
    private final JobExecutionInfoClient client;
    private Closer closer = Closer.create();

    public AdminClient(String host, int port) {
        URI serverUri = URI.create(String.format("http://%s:%d/", host, port));
        this.client = new JobExecutionInfoClient(serverUri.toString());
        this.closer.register((Closeable)this.client);
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Optional<JobExecutionInfo> queryByJobId(String id) throws RemoteInvocationException {
        JobExecutionQuery query = new JobExecutionQuery();
        query.setIdType(QueryIdTypeEnum.JOB_ID);
        query.setId(JobExecutionQuery.Id.create((String)id));
        query.setLimit(1);
        List<JobExecutionInfo> results = this.executeQuery(query);
        return AdminClient.getFirstFromQueryResults(results);
    }

    public List<JobExecutionInfo> queryAllJobs(QueryListType lookupType, int resultsLimit) throws RemoteInvocationException {
        JobExecutionQuery query = new JobExecutionQuery();
        query.setIdType(QueryIdTypeEnum.LIST_TYPE);
        query.setId(JobExecutionQuery.Id.create((QueryListType)lookupType));
        query.setJobProperties("job.runonce,job.schedule");
        query.setIncludeTaskExecutions(false);
        query.setLimit(resultsLimit);
        return this.executeQuery(query);
    }

    public List<JobExecutionInfo> queryByJobName(String name, int resultsLimit) throws RemoteInvocationException {
        JobExecutionQuery query = new JobExecutionQuery();
        query.setIdType(QueryIdTypeEnum.JOB_NAME);
        query.setId(JobExecutionQuery.Id.create((String)name));
        query.setIncludeTaskExecutions(false);
        query.setLimit(resultsLimit);
        return this.executeQuery(query);
    }

    private List<JobExecutionInfo> executeQuery(JobExecutionQuery query) throws RemoteInvocationException {
        JobExecutionQueryResult result = this.client.get(query);
        if (result != null && result.hasJobExecutions()) {
            return result.getJobExecutions();
        }
        return Collections.emptyList();
    }

    private static Optional<JobExecutionInfo> getFirstFromQueryResults(List<JobExecutionInfo> results) {
        if (results == null || results.size() == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)results.get(0));
    }
}

