/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import org.apache.gobblin.yarn.YarnHelixUtils;
import org.apache.gobblin.yarn.event.DelegationTokenUpdatedEvent;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnContainerSecurityManager
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnContainerSecurityManager.class);
    private final FileSystem fs;
    private final Path tokenFilePath;
    private final EventBus eventBus;

    public YarnContainerSecurityManager(Config config, FileSystem fs, EventBus eventBus) {
        this.fs = fs;
        this.tokenFilePath = new Path(this.fs.getHomeDirectory(), config.getString("gobblin.yarn.app.name") + "/" + ".token");
        this.eventBus = eventBus;
    }

    @Subscribe
    public void handleTokenFileUpdatedEvent(DelegationTokenUpdatedEvent delegationTokenUpdatedEvent) {
        try {
            this.addDelegationTokens(this.readDelegationTokens(this.tokenFilePath));
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
    }

    @VisibleForTesting
    Collection<Token<? extends TokenIdentifier>> readDelegationTokens(Path tokenFilePath) throws IOException {
        LOGGER.info("Reading updated token from token file: " + tokenFilePath);
        return YarnHelixUtils.readTokensFromFile(tokenFilePath, this.fs.getConf());
    }

    @VisibleForTesting
    void addDelegationTokens(Collection<Token<? extends TokenIdentifier>> tokens) throws IOException {
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (UserGroupInformation.getCurrentUser().addToken(token)) continue;
            LOGGER.error(String.format("Failed to add token %s to user %s", token.toString(), UserGroupInformation.getLoginUser().getShortUserName()));
        }
    }
}

