/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.FsStateStore;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

@Alias(value="fs")
public class FsStateStoreFactory
implements StateStore.Factory {
    @Override
    public <T extends State> StateStore<T> createStateStore(Config config, Class<T> stateClass) {
        Configuration conf = new Configuration();
        for (Map.Entry entry : config.entrySet()) {
            conf.set((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString());
        }
        try {
            String stateStoreFsUri = ConfigUtils.getString((Config)config, (String)"state.store.fs.uri", (String)"file:///");
            FileSystem stateStoreFs = FileSystem.get((URI)URI.create(stateStoreFsUri), (Configuration)conf);
            String stateStoreRootDir = config.getString("state.store.dir");
            return new FsStateStore<T>(stateStoreFs, stateStoreRootDir, stateClass);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create FsStateStore with factory", e);
        }
    }
}

