/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.FullEntityReader;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;

public class Messages {
    private Messages() {
    }

    public static void toRestRequest(StreamRequest streamRequest, final Callback<RestRequest> callback) {
        final RestRequestBuilder builder = new RestRequestBuilder(streamRequest);
        Callback<ByteString> assemblyCallback = new Callback<ByteString>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(ByteString result) {
                RestRequest restRequest = builder.setEntity(result).build();
                callback.onSuccess((Object)restRequest);
            }
        };
        streamRequest.getEntityStream().setReader(new FullEntityReader(assemblyCallback));
    }

    public static void toRestResponse(StreamResponse streamResponse, Callback<RestResponse> callback) {
        Messages.toRestResponse(streamResponse, callback, false);
    }

    public static void toRestResponse(StreamResponse streamResponse, final Callback<RestResponse> callback, final boolean addContentLengthHeader) {
        final RestResponseBuilder builder = new RestResponseBuilder(streamResponse);
        Callback<ByteString> assemblyCallback = new Callback<ByteString>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(ByteString result) {
                if (addContentLengthHeader) {
                    builder.setHeader("Content-Length", String.valueOf(result.length()));
                }
                RestResponse restResponse = builder.setEntity(result).build();
                callback.onSuccess((Object)restResponse);
            }
        };
        streamResponse.getEntityStream().setReader(new FullEntityReader(assemblyCallback));
    }

    public static StreamRequest toStreamRequest(RestRequest restRequest) {
        StreamRequestBuilder builder = new StreamRequestBuilder(restRequest);
        return builder.build(EntityStreams.newEntityStream(new ByteStringWriter(restRequest.getEntity())));
    }

    public static StreamResponse toStreamResponse(RestResponse restResponse) {
        StreamResponseBuilder builder = new StreamResponseBuilder(restResponse);
        return builder.build(EntityStreams.newEntityStream(new ByteStringWriter(restResponse.getEntity())));
    }

    public static void toRestException(StreamException streamException, Callback<RestException> callback) {
        Messages.toRestException(streamException, callback, false);
    }

    public static void toRestException(final StreamException streamException, final Callback<RestException> callback, boolean addContentLengthHeader) {
        Messages.toRestResponse(streamException.getResponse(), new Callback<RestResponse>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(RestResponse result) {
                callback.onSuccess((Object)new RestException(result, streamException.getMessage(), streamException.getCause()));
            }
        }, addContentLengthHeader);
    }

    public static StreamException toStreamException(RestException restException) {
        return new StreamException(Messages.toStreamResponse(restException.getResponse()), restException.getMessage(), restException.getCause());
    }

    public static Callback<StreamResponse> toStreamCallback(Callback<RestResponse> callback) {
        return Messages.toStreamCallback(callback, false);
    }

    public static Callback<StreamResponse> toStreamCallback(final Callback<RestResponse> callback, final boolean addContentLengthHeader) {
        return new Callback<StreamResponse>(){

            public void onError(Throwable originalException) {
                if (originalException instanceof StreamException) {
                    Messages.toRestException((StreamException)originalException, new Callback<RestException>(){

                        public void onError(Throwable e) {
                            callback.onError(e);
                        }

                        public void onSuccess(RestException restException) {
                            callback.onError((Throwable)restException);
                        }
                    }, addContentLengthHeader);
                } else {
                    callback.onError(originalException);
                }
            }

            public void onSuccess(StreamResponse streamResponse) {
                Messages.toRestResponse(streamResponse, new Callback<RestResponse>(){

                    public void onError(Throwable e) {
                        callback.onError(e);
                    }

                    public void onSuccess(RestResponse restResponse) {
                        callback.onSuccess((Object)restResponse);
                    }
                }, addContentLengthHeader);
            }
        };
    }

    public static Callback<RestResponse> toRestCallback(final Callback<StreamResponse> callback) {
        return new Callback<RestResponse>(){

            public void onError(Throwable e) {
                if (e instanceof RestException) {
                    callback.onError((Throwable)Messages.toStreamException((RestException)e));
                } else {
                    callback.onError(e);
                }
            }

            public void onSuccess(RestResponse result) {
                callback.onSuccess((Object)Messages.toStreamResponse(result));
            }
        };
    }

    public static TransportCallback<StreamResponse> toStreamTransportCallback(final TransportCallback<RestResponse> callback) {
        return response -> {
            if (response.hasError()) {
                Throwable throwable = response.getError();
                if (throwable instanceof StreamException) {
                    Messages.toRestException((StreamException)throwable, new Callback<RestException>(){

                        public void onError(Throwable e) {
                            callback.onResponse(TransportResponseImpl.error(e, response.getWireAttributes()));
                        }

                        public void onSuccess(RestException restException) {
                            callback.onResponse(TransportResponseImpl.error(restException, response.getWireAttributes()));
                        }
                    });
                } else {
                    callback.onResponse(TransportResponseImpl.error(throwable, response.getWireAttributes()));
                }
            } else {
                Messages.toRestResponse((StreamResponse)response.getResponse(), new Callback<RestResponse>(){

                    public void onError(Throwable e) {
                        callback.onResponse(TransportResponseImpl.error(e, response.getWireAttributes()));
                    }

                    public void onSuccess(RestResponse result) {
                        callback.onResponse(TransportResponseImpl.success(result, response.getWireAttributes()));
                    }
                });
            }
        };
    }

    public static TransportCallback<RestResponse> toRestTransportCallback(TransportCallback<StreamResponse> callback) {
        return response -> {
            if (response.hasError()) {
                Throwable throwable = response.getError();
                if (throwable instanceof RestException) {
                    callback.onResponse(TransportResponseImpl.error(Messages.toStreamException((RestException)throwable), response.getWireAttributes()));
                } else {
                    callback.onResponse(TransportResponseImpl.error(throwable, response.getWireAttributes()));
                }
            } else {
                callback.onResponse(TransportResponseImpl.success(Messages.toStreamResponse((RestResponse)response.getResponse()), response.getWireAttributes()));
            }
        };
    }
}

