/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;

public class quarantineInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"quarantineInfo\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"Config info for d2 quarantine feature\",\"fields\":[{\"name\":\"quarantineMaxPercent\",\"type\":\"double\",\"doc\":\"The percentage of the hosts that can be quarantined at the same time. It is also the switch to turn on Quarantine feature.\"},{\"name\":\"quarantineMethod\",\"type\":\"string\",\"doc\":\"Config the health checking method for quarantine. Format: <METHOD>:<FULL_PATH>. Default to OPTIONS method.\",\"optional\":true},{\"name\":\"quarantineLatency\",\"type\":\"long\",\"doc\":\"The latency threshold (in milliseconds) for health checking response. Responding time longer than this threshold is considered as unhealthy.\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_QuarantineMaxPercent = SCHEMA.getField("quarantineMaxPercent");
    private static final RecordDataSchema.Field FIELD_QuarantineMethod = SCHEMA.getField("quarantineMethod");
    private static final RecordDataSchema.Field FIELD_QuarantineLatency = SCHEMA.getField("quarantineLatency");

    public quarantineInfo() {
        super(new DataMap(), SCHEMA);
    }

    public quarantineInfo(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasQuarantineMaxPercent() {
        return this.contains(FIELD_QuarantineMaxPercent);
    }

    public void removeQuarantineMaxPercent() {
        this.remove(FIELD_QuarantineMaxPercent);
    }

    public Double getQuarantineMaxPercent(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_QuarantineMaxPercent, Double.class, mode);
    }

    public Double getQuarantineMaxPercent() {
        return (Double)this.obtainDirect(FIELD_QuarantineMaxPercent, Double.class, GetMode.STRICT);
    }

    public quarantineInfo setQuarantineMaxPercent(Double value, SetMode mode) {
        this.putDirect(FIELD_QuarantineMaxPercent, Double.class, Double.class, value, mode);
        return this;
    }

    public quarantineInfo setQuarantineMaxPercent(Double value) {
        this.putDirect(FIELD_QuarantineMaxPercent, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public quarantineInfo setQuarantineMaxPercent(double value) {
        this.putDirect(FIELD_QuarantineMaxPercent, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasQuarantineMethod() {
        return this.contains(FIELD_QuarantineMethod);
    }

    public void removeQuarantineMethod() {
        this.remove(FIELD_QuarantineMethod);
    }

    public String getQuarantineMethod(GetMode mode) {
        return (String)this.obtainDirect(FIELD_QuarantineMethod, String.class, mode);
    }

    public String getQuarantineMethod() {
        return (String)this.obtainDirect(FIELD_QuarantineMethod, String.class, GetMode.STRICT);
    }

    public quarantineInfo setQuarantineMethod(String value, SetMode mode) {
        this.putDirect(FIELD_QuarantineMethod, String.class, String.class, value, mode);
        return this;
    }

    public quarantineInfo setQuarantineMethod(String value) {
        this.putDirect(FIELD_QuarantineMethod, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasQuarantineLatency() {
        return this.contains(FIELD_QuarantineLatency);
    }

    public void removeQuarantineLatency() {
        this.remove(FIELD_QuarantineLatency);
    }

    public Long getQuarantineLatency(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_QuarantineLatency, Long.class, mode);
    }

    public Long getQuarantineLatency() {
        return (Long)this.obtainDirect(FIELD_QuarantineLatency, Long.class, GetMode.STRICT);
    }

    public quarantineInfo setQuarantineLatency(Long value, SetMode mode) {
        this.putDirect(FIELD_QuarantineLatency, Long.class, Long.class, value, mode);
        return this;
    }

    public quarantineInfo setQuarantineLatency(Long value) {
        this.putDirect(FIELD_QuarantineLatency, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public quarantineInfo setQuarantineLatency(long value) {
        this.putDirect(FIELD_QuarantineLatency, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public quarantineInfo clone() throws CloneNotSupportedException {
        return (quarantineInfo)super.clone();
    }

    public quarantineInfo copy() throws CloneNotSupportedException {
        return (quarantineInfo)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec quarantineMaxPercent() {
            return new PathSpec(this.getPathComponents(), "quarantineMaxPercent");
        }

        public PathSpec quarantineMethod() {
            return new PathSpec(this.getPathComponents(), "quarantineMethod");
        }

        public PathSpec quarantineLatency() {
            return new PathSpec(this.getPathComponents(), "quarantineLatency");
        }
    }
}

