/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventDataUtil;
import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class EventData
implements Serializable {
    private static final long serialVersionUID = -5631628195600014255L;
    private transient Binary bodyData;
    private Map<String, String> properties;
    private SystemProperties systemProperties;

    private EventData() {
    }

    EventData(Message amqpMessage) {
        if (amqpMessage == null) {
            throw new IllegalArgumentException("amqpMessage cannot be null");
        }
        Map messageAnnotations = amqpMessage.getMessageAnnotations().getValue();
        HashMap<String, Object> receiveProperties = new HashMap<String, Object>();
        for (Map.Entry annotation : messageAnnotations.entrySet()) {
            receiveProperties.put(((Symbol)annotation.getKey()).toString(), annotation.getValue() != null ? (Object)annotation.getValue() : null);
        }
        if (amqpMessage.getProperties() != null) {
            if (amqpMessage.getMessageId() != null) {
                receiveProperties.put("message-id", amqpMessage.getMessageId());
            }
            if (amqpMessage.getUserId() != null) {
                receiveProperties.put("user-id", amqpMessage.getUserId());
            }
            if (amqpMessage.getAddress() != null) {
                receiveProperties.put("to", amqpMessage.getAddress());
            }
            if (amqpMessage.getSubject() != null) {
                receiveProperties.put("subject", amqpMessage.getSubject());
            }
            if (amqpMessage.getReplyTo() != null) {
                receiveProperties.put("reply-to", amqpMessage.getReplyTo());
            }
            if (amqpMessage.getCorrelationId() != null) {
                receiveProperties.put("correlation-id", amqpMessage.getCorrelationId());
            }
            if (amqpMessage.getContentType() != null) {
                receiveProperties.put("content-type", amqpMessage.getContentType());
            }
            if (amqpMessage.getContentEncoding() != null) {
                receiveProperties.put("content-encoding", amqpMessage.getContentEncoding());
            }
            if (amqpMessage.getProperties().getAbsoluteExpiryTime() != null) {
                receiveProperties.put("absolute-expiry-time", amqpMessage.getExpiryTime());
            }
            if (amqpMessage.getProperties().getCreationTime() != null) {
                receiveProperties.put("creation-time", amqpMessage.getCreationTime());
            }
            if (amqpMessage.getGroupId() != null) {
                receiveProperties.put("group-id", amqpMessage.getGroupId());
            }
            if (amqpMessage.getProperties().getGroupSequence() != null) {
                receiveProperties.put("group-sequence", amqpMessage.getGroupSequence());
            }
            if (amqpMessage.getReplyToGroupId() != null) {
                receiveProperties.put("reply-to-group-id", amqpMessage.getReplyToGroupId());
            }
        }
        this.systemProperties = new SystemProperties(receiveProperties);
        this.properties = amqpMessage.getApplicationProperties() == null ? null : amqpMessage.getApplicationProperties().getValue();
        this.bodyData = amqpMessage.getBody() == null ? null : ((Data)amqpMessage.getBody()).getValue();
        amqpMessage.clear();
    }

    public EventData(byte[] data) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data);
    }

    public EventData(byte[] data, int offset, int length) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data, offset, length);
    }

    public EventData(ByteBuffer buffer) {
        this();
        if (buffer == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = Binary.create((ByteBuffer)buffer);
    }

    public byte[] getBody() {
        return this.bodyData == null ? null : this.bodyData.getArray();
    }

    public int getBodyOffset() {
        return this.bodyData == null ? 0 : this.bodyData.getArrayOffset();
    }

    public int getBodyLength() {
        return this.bodyData == null ? 0 : this.bodyData.getLength();
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Deprecated
    public void setProperties(Map<String, String> applicationProperties) {
        this.properties = applicationProperties;
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    Message toAmqpMessage() {
        Message amqpMessage = Proton.message();
        if (this.properties != null && !this.properties.isEmpty()) {
            ApplicationProperties applicationProperties = new ApplicationProperties(this.properties);
            amqpMessage.setApplicationProperties(applicationProperties);
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry systemProperty : this.systemProperties.entrySet()) {
                String propertyName = (String)systemProperty.getKey();
                if (EventDataUtil.RESERVED_SYSTEM_PROPERTIES.contains(propertyName)) continue;
                if (AmqpConstants.RESERVED_PROPERTY_NAMES.contains(propertyName)) {
                    switch (propertyName) {
                        case "message-id": {
                            amqpMessage.setMessageId(systemProperty.getValue());
                            break;
                        }
                        case "user-id": {
                            amqpMessage.setUserId((byte[])systemProperty.getValue());
                            break;
                        }
                        case "to": {
                            amqpMessage.setAddress((String)systemProperty.getValue());
                            break;
                        }
                        case "subject": {
                            amqpMessage.setSubject((String)systemProperty.getValue());
                            break;
                        }
                        case "reply-to": {
                            amqpMessage.setReplyTo((String)systemProperty.getValue());
                            break;
                        }
                        case "correlation-id": {
                            amqpMessage.setCorrelationId(systemProperty.getValue());
                            break;
                        }
                        case "content-type": {
                            amqpMessage.setContentType((String)systemProperty.getValue());
                            break;
                        }
                        case "content-encoding": {
                            amqpMessage.setContentEncoding((String)systemProperty.getValue());
                            break;
                        }
                        case "absolute-expiry-time": {
                            amqpMessage.setExpiryTime(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "creation-time": {
                            amqpMessage.setCreationTime(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "group-id": {
                            amqpMessage.setGroupId((String)systemProperty.getValue());
                            break;
                        }
                        case "group-sequence": {
                            amqpMessage.setGroupSequence(((Long)systemProperty.getValue()).longValue());
                            break;
                        }
                        case "reply-to-group-id": {
                            amqpMessage.setReplyToGroupId((String)systemProperty.getValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("unreachable");
                        }
                    }
                    continue;
                }
                MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : amqpMessage.getMessageAnnotations();
                messageAnnotations.getValue().put(Symbol.getSymbol((String)((String)systemProperty.getKey())), systemProperty.getValue());
                amqpMessage.setMessageAnnotations(messageAnnotations);
            }
        }
        if (this.bodyData != null) {
            amqpMessage.setBody((Section)new Data(this.bodyData));
        }
        return amqpMessage;
    }

    Message toAmqpMessage(String partitionKey) {
        Message amqpMessage = this.toAmqpMessage();
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : amqpMessage.getMessageAnnotations();
        messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
        amqpMessage.setMessageAnnotations(messageAnnotations);
        return amqpMessage;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.bodyData.getLength());
        out.write(this.bodyData.getArray(), this.bodyData.getArrayOffset(), this.bodyData.getLength());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.read(data, 0, length);
        this.bodyData = new Binary(data, 0, length);
    }

    public static class SystemProperties
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -2827050124966993723L;

        public SystemProperties(HashMap<String, Object> map) {
            super(Collections.unmodifiableMap(map));
        }

        public String getOffset() {
            return (String)this.getSystemProperty("x-opt-offset");
        }

        public String getPartitionKey() {
            return (String)this.getSystemProperty("x-opt-partition-key");
        }

        public Instant getEnqueuedTime() {
            Date enqueuedTimeValue = (Date)this.getSystemProperty("x-opt-enqueued-time");
            return enqueuedTimeValue != null ? enqueuedTimeValue.toInstant() : null;
        }

        public long getSequenceNumber() {
            return (Long)this.getSystemProperty("x-opt-sequence-number");
        }

        public String getPublisher() {
            return (String)this.getSystemProperty("x-opt-publisher");
        }

        private <T> T getSystemProperty(String key) {
            if (this.containsKey(key)) {
                return (T)this.get(key);
            }
            return null;
        }
    }
}

