/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

import com.linkedin.common.Version;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.InvalidAlternativeKeyException;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.OperationNameGenerator;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.server.PathKeysImpl;
import com.linkedin.restli.internal.server.ResourceContextImpl;
import com.linkedin.restli.internal.server.ResourceMethodMatchKey;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.util.AlternativeKeyCoercerException;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.MIMEParse;
import com.linkedin.restli.internal.server.util.RestLiSyntaxException;
import com.linkedin.restli.server.Key;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiRouter {
    private static final Logger log = LoggerFactory.getLogger(RestLiRouter.class);
    private static final Map<ResourceMethodMatchKey, ResourceMethod> _resourceMethodLookup = RestLiRouter.setupResourceMethodLookup();
    private final Map<String, ResourceModel> _pathRootResourceMap;
    private static final Pattern SLASH_PATTERN = Pattern.compile(Pattern.quote("/"));

    public RestLiRouter(Map<String, ResourceModel> pathRootResourceMap) {
        this._pathRootResourceMap = pathRootResourceMap;
    }

    public RoutingResult process(RestRequest req, RequestContext requestContext, RestLiAttachmentReader attachmentReader) {
        ResourceContextImpl context;
        ResourceModel currentResource;
        String path = req.getURI().getRawPath();
        if (path.length() < 2) {
            throw new RoutingException(HttpStatus.S_404_NOT_FOUND.getCode());
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        LinkedList<String> remainingPath = new LinkedList<String>(Arrays.asList(SLASH_PATTERN.split(path)));
        String rootPath = "/" + (String)remainingPath.poll();
        try {
            currentResource = this._pathRootResourceMap.get(URLDecoder.decode(rootPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RestLiInternalException("UnsupportedEncodingException while trying to decode the root path", e);
        }
        if (currentResource == null) {
            throw new RoutingException(String.format("No root resource defined for path '%s'", rootPath), HttpStatus.S_404_NOT_FOUND.getCode());
        }
        try {
            String acceptTypeHeader = req.getHeader("Accept");
            boolean responseAttachmentsAllowed = false;
            if (acceptTypeHeader != null) {
                List<String> acceptTypes = MIMEParse.parseAcceptType(acceptTypeHeader);
                for (String acceptType : acceptTypes) {
                    if (!acceptType.equalsIgnoreCase("multipart/related")) continue;
                    responseAttachmentsAllowed = true;
                }
            }
            context = new ResourceContextImpl(new PathKeysImpl(), req, requestContext, responseAttachmentsAllowed, attachmentReader);
        }
        catch (RestLiSyntaxException e) {
            throw new RoutingException(e.getMessage(), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        return this.processResourceTree(currentResource, context, remainingPath);
    }

    private RoutingResult processResourceTree(ResourceModel resource, ServerResourceContext context, Queue<String> remainingPath) {
        ResourceModel currentResource = resource;
        ResourceLevel currentLevel = currentResource.getResourceLevel();
        while (remainingPath.peek() != null) {
            String currentPathSegment = remainingPath.poll();
            if (currentLevel.equals((Object)ResourceLevel.ENTITY)) {
                currentLevel = (currentResource = currentResource.getSubResource(RestLiRouter.parseSubresourceName(currentPathSegment))) == null ? ResourceLevel.ANY : currentResource.getResourceLevel();
            } else {
                ResourceModel currentCollectionResource = currentResource;
                if (currentResource.getKeys().isEmpty()) {
                    throw new RoutingException(String.format("Path key not supported on resource '%s' for URI '%s'", currentResource.getName(), context.getRequestURI()), HttpStatus.S_400_BAD_REQUEST.getCode());
                }
                if (context.getParameters().containsKey((Object)"altkey")) {
                    RestLiRouter.parseAlternativeKey(currentResource, context, currentPathSegment);
                    currentLevel = ResourceLevel.ENTITY;
                } else if (currentResource.getKeyClass() == ComplexResourceKey.class) {
                    RestLiRouter.parseComplexKey(currentResource, context, currentPathSegment);
                    currentLevel = ResourceLevel.ENTITY;
                } else if (currentResource.getKeyClass() == CompoundKey.class) {
                    CompoundKey compoundKey;
                    try {
                        compoundKey = RestLiRouter.parseCompoundKey(currentCollectionResource, context, currentPathSegment);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RoutingException(String.format("Malformed Compound Key: '%s'", currentPathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
                    }
                    if (compoundKey != null && compoundKey.getPartKeys().containsAll(currentResource.getKeyNames())) {
                        currentLevel = ResourceLevel.ENTITY;
                    }
                } else {
                    RestLiRouter.parseSimpleKey(currentResource, context, currentPathSegment);
                    currentLevel = ResourceLevel.ENTITY;
                }
            }
            if (currentResource != null) continue;
            throw new RoutingException(HttpStatus.S_404_NOT_FOUND.getCode());
        }
        this.parseBatchKeysParameter(currentResource, context);
        return this.findMethodDescriptor(currentResource, currentLevel, context);
    }

    private static String parseSubresourceName(String pathSegment) {
        try {
            return URLDecoder.decode(pathSegment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RestLiInternalException("UnsupportedEncodingException while trying to decode the subresource name", e);
        }
    }

    private RoutingResult findMethodDescriptor(ResourceModel resource, ResourceLevel resourceLevel, ServerResourceContext context) {
        ResourceMethodDescriptor methodDescriptor;
        ResourceMethod type = this.mapResourceMethod(context, resourceLevel);
        String methodName = context.getRequestActionName();
        if (methodName == null) {
            methodName = context.getRequestFinderName();
        }
        if ((methodDescriptor = resource.matchMethod(type, methodName, resourceLevel)) != null) {
            context.getRawRequestContext().putLocalAttr("OPERATION", (Object)OperationNameGenerator.generate((ResourceMethod)methodDescriptor.getMethodType(), (String)methodName));
            return new RoutingResult(context, methodDescriptor);
        }
        String httpMethod = context.getRequestMethod();
        if (methodName != null) {
            throw new RoutingException(String.format("%s operation named %s not supported on resource '%s' URI: '%s'", httpMethod, methodName, resource.getResourceClass().getName(), context.getRequestURI().toString()), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        throw new RoutingException(String.format("%s operation not supported for URI: '%s' with X-RestLi-Method: '%s'", httpMethod, context.getRequestURI().toString(), context.getRestLiRequestMethod()), HttpStatus.S_400_BAD_REQUEST.getCode());
    }

    private static Map<ResourceMethodMatchKey, ResourceMethod> setupResourceMethodLookup() {
        HashMap<ResourceMethodMatchKey, ResourceMethod> result = new HashMap<ResourceMethodMatchKey, ResourceMethod>();
        Object[] config = new Object[]{new ResourceMethodMatchKey("GET", "", false, false, false, true), ResourceMethod.GET, new ResourceMethodMatchKey("GET", "", false, true, false, false), ResourceMethod.FINDER, new ResourceMethodMatchKey("PUT", "", false, false, false, true), ResourceMethod.UPDATE, new ResourceMethodMatchKey("POST", "", false, false, false, true), ResourceMethod.PARTIAL_UPDATE, new ResourceMethodMatchKey("DELETE", "", false, false, false, true), ResourceMethod.DELETE, new ResourceMethodMatchKey("POST", "", true, false, false, true), ResourceMethod.ACTION, new ResourceMethodMatchKey("POST", "", true, false, false, false), ResourceMethod.ACTION, new ResourceMethodMatchKey("POST", "", false, false, false, false), ResourceMethod.CREATE, new ResourceMethodMatchKey("GET", "", false, false, false, false), ResourceMethod.GET_ALL, new ResourceMethodMatchKey("GET", "GET", false, false, false, true), ResourceMethod.GET, new ResourceMethodMatchKey("GET", "FINDER", false, true, false, false), ResourceMethod.FINDER, new ResourceMethodMatchKey("PUT", "UPDATE", false, false, false, true), ResourceMethod.UPDATE, new ResourceMethodMatchKey("POST", "PARTIAL_UPDATE", false, false, false, true), ResourceMethod.PARTIAL_UPDATE, new ResourceMethodMatchKey("DELETE", "DELETE", false, false, false, true), ResourceMethod.DELETE, new ResourceMethodMatchKey("POST", "ACTION", true, false, false, true), ResourceMethod.ACTION, new ResourceMethodMatchKey("POST", "ACTION", true, false, false, false), ResourceMethod.ACTION, new ResourceMethodMatchKey("POST", "CREATE", false, false, false, false), ResourceMethod.CREATE, new ResourceMethodMatchKey("GET", "GET_ALL", false, false, false, false), ResourceMethod.GET_ALL, new ResourceMethodMatchKey("GET", "", false, false, true, false), ResourceMethod.BATCH_GET, new ResourceMethodMatchKey("DELETE", "", false, false, true, false), ResourceMethod.BATCH_DELETE, new ResourceMethodMatchKey("PUT", "", false, false, true, false), ResourceMethod.BATCH_UPDATE, new ResourceMethodMatchKey("POST", "", false, false, true, false), ResourceMethod.BATCH_PARTIAL_UPDATE, new ResourceMethodMatchKey("GET", "BATCH_GET", false, false, true, false), ResourceMethod.BATCH_GET, new ResourceMethodMatchKey("DELETE", "BATCH_DELETE", false, false, true, false), ResourceMethod.BATCH_DELETE, new ResourceMethodMatchKey("PUT", "BATCH_UPDATE", false, false, true, false), ResourceMethod.BATCH_UPDATE, new ResourceMethodMatchKey("POST", "BATCH_PARTIAL_UPDATE", false, false, true, false), ResourceMethod.BATCH_PARTIAL_UPDATE, new ResourceMethodMatchKey("POST", "BATCH_CREATE", false, false, false, false), ResourceMethod.BATCH_CREATE};
        for (int ii = 0; ii < config.length; ii += 2) {
            ResourceMethodMatchKey key = (ResourceMethodMatchKey)config[ii];
            ResourceMethod method = (ResourceMethod)config[ii + 1];
            ResourceMethod prevValue = result.put(key, method);
            if (prevValue == null) continue;
            throw new RestLiInternalException("Routing Configuration conflict: " + prevValue.toString() + " conflicts with " + method.toString());
        }
        return result;
    }

    private ResourceMethod mapResourceMethod(ServerResourceContext context, ResourceLevel resourceLevel) {
        ResourceMethodMatchKey key = new ResourceMethodMatchKey(context.getRequestMethod(), context.getRestLiRequestMethod(), context.getRequestActionName() != null, context.getRequestFinderName() != null, context.getPathKeys().getBatchIds() != null, resourceLevel.equals((Object)ResourceLevel.ENTITY));
        if (_resourceMethodLookup.containsKey(key)) {
            return _resourceMethodLookup.get(key);
        }
        if (context.hasParameter("action") && !"POST".equalsIgnoreCase(context.getRequestMethod())) {
            throw new RoutingException(String.format("All action methods (specified via '%s' in URI) must be submitted as a POST (was %s)", "action", context.getRequestMethod()), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        throw new RoutingException(String.format("Method '%s' is not supported for URI '%s'", context.getRequestMethod(), context.getRequestURI()), HttpStatus.S_400_BAD_REQUEST.getCode());
    }

    private static CompoundKey parseCompoundKey(ResourceModel resource, ServerResourceContext context, String pathSegment) {
        CompoundKey compoundKey;
        try {
            compoundKey = ArgumentUtils.parseCompoundKey(pathSegment, resource.getKeys(), context.getRestliProtocolVersion());
        }
        catch (PathSegment.PathSegmentSyntaxException e) {
            throw new RoutingException(String.format("input %s is not a Compound key", pathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RoutingException(String.format("input %s is not a Compound key", pathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        catch (TemplateRuntimeException e) {
            throw new RoutingException(String.format("Compound key parameter value %s is invalid", pathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        for (String simpleKeyName : compoundKey.getPartKeys()) {
            context.getPathKeys().append(simpleKeyName, compoundKey.getPart(simpleKeyName));
        }
        context.getPathKeys().append(resource.getKeyName(), compoundKey);
        return compoundKey;
    }

    private static <K> void parseAlternativeKey(ResourceModel resource, ServerResourceContext context, String currentPathSegment) {
        Object alternativeKey;
        String altKeyName = context.getParameter("altkey");
        try {
            alternativeKey = ArgumentUtils.parseAlternativeKey(currentPathSegment, context.getParameter("altkey"), resource, context.getRestliProtocolVersion());
        }
        catch (IllegalArgumentException e) {
            throw new RoutingException(e.getMessage(), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        try {
            Object canonicalKey = ArgumentUtils.translateFromAlternativeKey(alternativeKey, altKeyName, resource);
            context.getPathKeys().append(resource.getKeyName(), canonicalKey);
        }
        catch (InvalidAlternativeKeyException e) {
            throw new RoutingException(e.getMessage(), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        catch (AlternativeKeyCoercerException e) {
            throw new RoutingException("KeyCoercer threw an unexpected exception", HttpStatus.S_500_INTERNAL_SERVER_ERROR.getCode(), e);
        }
    }

    private static void parseComplexKey(ResourceModel resource, ServerResourceContext context, String currentPathSegment) {
        try {
            ComplexKeySpec complexKeyType = ComplexKeySpec.forClassesMaybeNull(resource.getKeyKeyClass(), resource.getKeyParamsClass());
            ComplexResourceKey complexKey = ComplexResourceKey.parseString((String)currentPathSegment, (ComplexKeySpec)complexKeyType, (ProtocolVersion)context.getRestliProtocolVersion());
            context.getPathKeys().append(resource.getKeyName(), complexKey);
        }
        catch (PathSegment.PathSegmentSyntaxException e) {
            throw new RoutingException(String.format("Complex key query parameters parsing error: '%s'", e.getMessage()), HttpStatus.S_400_BAD_REQUEST.getCode());
        }
    }

    private void parseBatchKeysParameter(ResourceModel resource, ServerResourceContext context) {
        Set<Object> batchKeys;
        block30: {
            Class<?> keyClass = resource.getKeyClass();
            ProtocolVersion version = context.getRestliProtocolVersion();
            try {
                if (context.getParameters().containsKey((Object)"altkey")) {
                    batchKeys = RestLiRouter.parseAlternativeBatchKeys(resource, context);
                    break block30;
                }
                if (ComplexResourceKey.class.equals(keyClass)) {
                    DataMap allParametersDataMap = context.getParameters();
                    DataList batchIds = allParametersDataMap.getDataList("ids");
                    if (batchIds == null) {
                        batchKeys = null;
                    } else if (batchIds.isEmpty()) {
                        batchKeys = Collections.emptySet();
                    } else {
                        batchKeys = new HashSet<Object>();
                        for (Object complexKey : batchIds) {
                            if (!(complexKey instanceof DataMap)) {
                                log.warn("Invalid structure of key '" + complexKey.toString() + "', skipping key.");
                                context.getBatchKeyErrors().put(complexKey, new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST));
                                continue;
                            }
                            batchKeys.add(ComplexResourceKey.buildFromDataMap((DataMap)((DataMap)complexKey), (ComplexKeySpec)ComplexKeySpec.forClassesMaybeNull(resource.getKeyKeyClass(), resource.getKeyParamsClass())));
                        }
                    }
                    break block30;
                }
                if (CompoundKey.class.equals(keyClass) && version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
                    DataMap allParametersDataMap = context.getParameters();
                    DataList batchIds = allParametersDataMap.getDataList("ids");
                    if (batchIds == null) {
                        batchKeys = null;
                        break block30;
                    }
                    if (batchIds.isEmpty()) {
                        batchKeys = Collections.emptySet();
                        break block30;
                    }
                    batchKeys = new HashSet<Object>();
                    for (Object compoundKey : batchIds) {
                        CompoundKey finalKey;
                        if (!(compoundKey instanceof DataMap)) {
                            log.warn("Invalid structure of key '" + compoundKey.toString() + "', skipping key.");
                            context.getBatchKeyErrors().put(compoundKey.toString(), new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST));
                            continue;
                        }
                        try {
                            finalKey = ArgumentUtils.dataMapToCompoundKey((DataMap)compoundKey, resource.getKeys());
                        }
                        catch (IllegalArgumentException e) {
                            log.warn("Invalid structure of key '" + compoundKey.toString() + "', skipping key.");
                            context.getBatchKeyErrors().put(compoundKey.toString(), new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST));
                            continue;
                        }
                        batchKeys.add(finalKey);
                    }
                    break block30;
                }
                if (context.hasParameter("ids")) {
                    batchKeys = new HashSet<Object>();
                    List<String> ids = context.getParameterValues("ids");
                    if (version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
                        for (String id : ids) {
                            Key key = resource.getPrimaryKey();
                            try {
                                Object value = ArgumentUtils.convertSimpleValue(id, key.getDataSchema(), key.getType());
                                batchKeys.add(value);
                            }
                            catch (NumberFormatException e) {
                                throw new RoutingException("NumberFormatException parsing batch key '" + id + "'", HttpStatus.S_400_BAD_REQUEST.getCode(), e);
                            }
                            catch (IllegalArgumentException e) {
                                throw new RoutingException("IllegalArgumentException parsing batch key '" + id + "'", HttpStatus.S_400_BAD_REQUEST.getCode(), e);
                            }
                        }
                    } else {
                        for (String id : ids) {
                            try {
                                Object value = RestLiRouter.parseKeyFromBatchV1(id, resource);
                                batchKeys.add(value);
                            }
                            catch (NumberFormatException e) {
                                log.warn("Caught NumberFormatException parsing batch key '" + id + "', skipping key.");
                                context.getBatchKeyErrors().put(id, new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, null, e));
                            }
                            catch (IllegalArgumentException e) {
                                log.warn("Caught IllegalArgumentException parsing batch key '" + id + "', skipping key.");
                                context.getBatchKeyErrors().put(id, new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, null, e));
                            }
                            catch (PathSegment.PathSegmentSyntaxException e) {
                                log.warn("Caught IllegalArgumentException parsing batch key '" + id + "', skipping key.");
                                context.getBatchKeyErrors().put(id, new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, null, e));
                            }
                        }
                    }
                } else {
                    batchKeys = null;
                }
            }
            catch (TemplateRuntimeException e) {
                throw new RoutingException("Batch key parameter value is invalid", HttpStatus.S_400_BAD_REQUEST.getCode(), e);
            }
        }
        context.getPathKeys().setBatchKeys(batchKeys);
    }

    private static Set<Object> parseAlternativeBatchKeys(ResourceModel resource, ServerResourceContext context) {
        String altKeyName = context.getParameter("altkey");
        List<String> ids = context.getParameterValues("ids");
        Set<Object> batchKeys = new HashSet<Object>();
        if (ids == null) {
            batchKeys = null;
        } else if (ids.isEmpty()) {
            batchKeys = Collections.emptySet();
        } else {
            if (!resource.getAlternativeKeys().containsKey(altKeyName)) {
                throw new RoutingException(String.format("Resource '%s' does not have an alternative key named '%s'", resource.getName(), altKeyName), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            for (String id : ids) {
                try {
                    batchKeys.add(ArgumentUtils.translateFromAlternativeKey(ArgumentUtils.parseAlternativeKey(id, altKeyName, resource, context.getRestliProtocolVersion()), altKeyName, resource));
                }
                catch (InvalidAlternativeKeyException e) {
                    log.warn(String.format("Invalid alternative key '%s', skipping key.", id));
                    context.getBatchKeyErrors().put(id, new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, (Throwable)e));
                }
                catch (AlternativeKeyCoercerException e) {
                    throw new RoutingException(String.format("Unexpected error when coercing alternative key '%s': %s", id, e.getMessage()), HttpStatus.S_500_INTERNAL_SERVER_ERROR.getCode());
                }
            }
        }
        return batchKeys;
    }

    private static void parseSimpleKey(ResourceModel resource, ServerResourceContext context, String pathSegment) {
        Object parsedKey;
        try {
            parsedKey = ArgumentUtils.parseSimplePathKey(pathSegment, resource, context.getRestliProtocolVersion());
        }
        catch (NumberFormatException e) {
            throw new RoutingException(String.format("Key value '%s' must be of type '%s'", pathSegment, resource.getKeyClass().getName()), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RoutingException(String.format("Key parameter value '%s' is invalid", pathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        catch (TemplateRuntimeException e) {
            throw new RoutingException(String.format("Key parameter value '%s' is invalid", pathSegment), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
        context.getPathKeys().append(resource.getKeyName(), parsedKey);
    }

    private static Object parseKeyFromBatchV1(String value, ResourceModel resource) throws PathSegment.PathSegmentSyntaxException, IllegalArgumentException {
        ProtocolVersion version = AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion();
        if (CompoundKey.class.isAssignableFrom(resource.getKeyClass())) {
            return ArgumentUtils.parseCompoundKey(value, resource.getKeys(), version);
        }
        Key key = resource.getPrimaryKey();
        return ArgumentUtils.convertSimpleValue(value, key.getDataSchema(), key.getType());
    }
}

