/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods;

import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.methods.arguments.ActionArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.BatchCreateArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.BatchDeleteArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.BatchGetArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.BatchPatchArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.BatchUpdateArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.CollectionArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.CreateArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.GetArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.PatchArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.UpdateArgumentBuilder;
import com.linkedin.restli.internal.server.response.ActionResponseBuilder;
import com.linkedin.restli.internal.server.response.BatchCreateResponseBuilder;
import com.linkedin.restli.internal.server.response.BatchGetResponseBuilder;
import com.linkedin.restli.internal.server.response.BatchUpdateResponseBuilder;
import com.linkedin.restli.internal.server.response.CollectionResponseBuilder;
import com.linkedin.restli.internal.server.response.CreateResponseBuilder;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.GetResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.UpdateResponseBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MethodAdapterRegistry {
    private final Map<ResourceMethod, RestLiArgumentBuilder> _adapters = this.buildAdapterRegistry();
    private final Map<ResourceMethod, RestLiResponseBuilder> _responseBuilders;

    public MethodAdapterRegistry(ErrorResponseBuilder errorResponseBuilder) {
        this._responseBuilders = this.buildResponseBuilders(errorResponseBuilder);
    }

    private Map<ResourceMethod, RestLiArgumentBuilder> buildAdapterRegistry() {
        HashMap<ResourceMethod, RestLiArgumentBuilder> result = new HashMap<ResourceMethod, RestLiArgumentBuilder>(ResourceMethod.values().length);
        result.put(ResourceMethod.GET, new GetArgumentBuilder());
        result.put(ResourceMethod.BATCH_GET, new BatchGetArgumentBuilder());
        result.put(ResourceMethod.FINDER, new CollectionArgumentBuilder());
        result.put(ResourceMethod.CREATE, new CreateArgumentBuilder());
        result.put(ResourceMethod.PARTIAL_UPDATE, new PatchArgumentBuilder());
        result.put(ResourceMethod.UPDATE, new UpdateArgumentBuilder());
        result.put(ResourceMethod.DELETE, new GetArgumentBuilder());
        result.put(ResourceMethod.ACTION, new ActionArgumentBuilder());
        result.put(ResourceMethod.BATCH_UPDATE, new BatchUpdateArgumentBuilder());
        result.put(ResourceMethod.BATCH_PARTIAL_UPDATE, new BatchPatchArgumentBuilder());
        result.put(ResourceMethod.BATCH_CREATE, new BatchCreateArgumentBuilder());
        result.put(ResourceMethod.BATCH_DELETE, new BatchDeleteArgumentBuilder());
        result.put(ResourceMethod.GET_ALL, new CollectionArgumentBuilder());
        return Collections.unmodifiableMap(result);
    }

    private Map<ResourceMethod, RestLiResponseBuilder> buildResponseBuilders(ErrorResponseBuilder errorResponseBuilder) {
        HashMap<ResourceMethod, RestLiResponseBuilder> result = new HashMap<ResourceMethod, RestLiResponseBuilder>(ResourceMethod.values().length);
        result.put(ResourceMethod.GET, new GetResponseBuilder());
        result.put(ResourceMethod.BATCH_GET, new BatchGetResponseBuilder(errorResponseBuilder));
        result.put(ResourceMethod.FINDER, new CollectionResponseBuilder());
        result.put(ResourceMethod.CREATE, new CreateResponseBuilder());
        result.put(ResourceMethod.PARTIAL_UPDATE, new UpdateResponseBuilder());
        result.put(ResourceMethod.UPDATE, new UpdateResponseBuilder());
        result.put(ResourceMethod.DELETE, new UpdateResponseBuilder());
        result.put(ResourceMethod.ACTION, new ActionResponseBuilder());
        result.put(ResourceMethod.BATCH_UPDATE, new BatchUpdateResponseBuilder(errorResponseBuilder));
        result.put(ResourceMethod.BATCH_PARTIAL_UPDATE, new BatchUpdateResponseBuilder(errorResponseBuilder));
        result.put(ResourceMethod.BATCH_CREATE, new BatchCreateResponseBuilder(errorResponseBuilder));
        result.put(ResourceMethod.BATCH_DELETE, new BatchUpdateResponseBuilder(errorResponseBuilder));
        result.put(ResourceMethod.GET_ALL, new CollectionResponseBuilder());
        return Collections.unmodifiableMap(result);
    }

    public RestLiArgumentBuilder getArgumentBuilder(ResourceMethod resourceMethod) {
        return this._adapters.get(resourceMethod);
    }

    public RestLiResponseBuilder getResponsebuilder(ResourceMethod resourceMethod) {
        return this._responseBuilders.get(resourceMethod);
    }
}

