/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.ActionResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.response.ActionResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.server.ActionResult;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

public class ActionResponseBuilder
implements RestLiResponseBuilder {
    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        return new PartialRestResponse.Builder().status(responseData.getStatus()).entity(responseData.getRecordResponseEnvelope().getRecord()).headers(responseData.getHeaders()).cookies(responseData.getCookies()).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        HttpStatus status;
        Object value;
        if (result instanceof ActionResult) {
            ActionResult actionResult = (ActionResult)result;
            value = actionResult.getValue();
            status = actionResult.getStatus();
            if (status == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null HttpStatus inside of an ActionResult returned by the resource method: " + routingResult.getResourceMethod());
            }
        } else {
            value = result;
            status = HttpStatus.S_200_OK;
        }
        RecordDataSchema actionReturnRecordDataSchema = routingResult.getResourceMethod().getActionReturnRecordDataSchema();
        FieldDef<?> actionReturnFieldDef = routingResult.getResourceMethod().getActionReturnFieldDef();
        ActionResponse actionResponse = new ActionResponse(value, actionReturnFieldDef, actionReturnRecordDataSchema);
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(status, headers, cookies);
        responseData.setResponseEnvelope(new ActionResponseEnvelope((RecordTemplate)actionResponse, responseData));
        return responseData;
    }
}

