/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.StripeStatistics;

public final class FileDump {
    private static final String ROWINDEX_PREFIX = "--rowindex=";

    private FileDump() {
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<Integer> rowIndexCols = null;
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if (arg.startsWith(ROWINDEX_PREFIX)) {
                    String[] colStrs = arg.substring(ROWINDEX_PREFIX.length()).split(",");
                    rowIndexCols = new ArrayList<Integer>(colStrs.length);
                    for (String colStr : colStrs) {
                        rowIndexCols.add(Integer.parseInt(colStr));
                    }
                    continue;
                }
                System.err.println("Unknown argument " + arg);
                continue;
            }
            files.add(arg);
        }
        for (String filename : files) {
            System.out.println("Structure for " + filename);
            Path path = new Path(filename);
            Reader reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
            System.out.println("File Version: " + reader.getFileVersion().getName() + " with " + (Object)((Object)reader.getWriterVersion()));
            RecordReaderImpl rows = (RecordReaderImpl)reader.rows();
            System.out.println("Rows: " + reader.getNumberOfRows());
            System.out.println("Compression: " + (Object)((Object)reader.getCompression()));
            if (reader.getCompression() != CompressionKind.NONE) {
                System.out.println("Compression size: " + reader.getCompressionSize());
            }
            System.out.println("Type: " + reader.getObjectInspector().getTypeName());
            System.out.println("\nStripe Statistics:");
            Metadata metadata = reader.getMetadata();
            for (int n = 0; n < metadata.getStripeStatistics().size(); ++n) {
                System.out.println("  Stripe " + (n + 1) + ":");
                StripeStatistics ss = metadata.getStripeStatistics().get(n);
                for (int i = 0; i < ss.getColumnStatistics().length; ++i) {
                    System.out.println("    Column " + i + ": " + ss.getColumnStatistics()[i].toString());
                }
            }
            ColumnStatistics[] stats = reader.getStatistics();
            System.out.println("\nFile Statistics:");
            for (int i = 0; i < stats.length; ++i) {
                System.out.println("  Column " + i + ": " + stats[i].toString());
            }
            System.out.println("\nStripes:");
            int stripeIx = -1;
            for (StripeInformation stripe : reader.getStripes()) {
                ++stripeIx;
                long stripeStart = stripe.getOffset();
                System.out.println("  Stripe: " + stripe.toString());
                OrcProto.StripeFooter footer = rows.readStripeFooter(stripe);
                long sectionStart = stripeStart;
                for (OrcProto.Stream section : footer.getStreamsList()) {
                    System.out.println("    Stream: column " + section.getColumn() + " section " + (Object)((Object)section.getKind()) + " start: " + sectionStart + " length " + section.getLength());
                    sectionStart += section.getLength();
                }
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    StringBuilder buf = new StringBuilder();
                    buf.append("    Encoding column ");
                    buf.append(i);
                    buf.append(": ");
                    buf.append((Object)encoding.getKind());
                    if (encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY || encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                        buf.append("[");
                        buf.append(encoding.getDictionarySize());
                        buf.append("]");
                    }
                    System.out.println(buf);
                }
                if (rowIndexCols == null) continue;
                OrcProto.RowIndex[] indices = rows.readRowIndex(stripeIx);
                Iterator i$ = rowIndexCols.iterator();
                while (i$.hasNext()) {
                    int col = (Integer)i$.next();
                    StringBuilder buf = new StringBuilder();
                    buf.append("    Row group index column ").append(col).append(":");
                    OrcProto.RowIndex index = null;
                    if (col >= indices.length || (index = indices[col]) == null) {
                        buf.append(" not found\n");
                        continue;
                    }
                    for (int entryIx = 0; entryIx < index.getEntryCount(); ++entryIx) {
                        buf.append("\n      Entry ").append(entryIx).append(":");
                        OrcProto.RowIndexEntry entry = index.getEntry(entryIx);
                        if (entry == null) {
                            buf.append("unknown\n");
                            continue;
                        }
                        OrcProto.ColumnStatistics colStats = entry.getStatistics();
                        if (colStats == null) {
                            buf.append("no stats at ");
                        } else {
                            ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(colStats);
                            Object min = RecordReaderImpl.getMin(cs);
                            Object max = RecordReaderImpl.getMax(cs);
                            buf.append(" count: ").append(cs.getNumberOfValues());
                            buf.append(" min: ").append(min);
                            buf.append(" max: ").append(max);
                        }
                        buf.append(" positions: ");
                        for (int posIx = 0; posIx < entry.getPositionsCount(); ++posIx) {
                            if (posIx != 0) {
                                buf.append(",");
                            }
                            buf.append(entry.getPositions(posIx));
                        }
                    }
                    System.out.println(buf);
                }
            }
            FileSystem fs = path.getFileSystem(conf);
            long fileLen = fs.getContentSummary(path).getLength();
            long paddedBytes = FileDump.getTotalPaddingSize(reader);
            double percentPadding = (double)paddedBytes / (double)fileLen * 100.0;
            DecimalFormat format = new DecimalFormat("##.##");
            System.out.println("\nFile length: " + fileLen + " bytes");
            System.out.println("Padding length: " + paddedBytes + " bytes");
            System.out.println("Padding ratio: " + format.format(percentPadding) + "%");
            rows.close();
        }
    }

    private static long getTotalPaddingSize(Reader reader) throws IOException {
        long paddedBytes = 0L;
        List<StripeInformation> stripes = reader.getStripes();
        for (int i = 1; i < stripes.size(); ++i) {
            long prevStripeOffset = stripes.get(i - 1).getOffset();
            long prevStripeLen = stripes.get(i - 1).getLength();
            paddedBytes += stripes.get(i).getOffset() - (prevStripeOffset + prevStripeLen);
        }
        return paddedBytes;
    }
}

