/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.reloperators;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.optiq.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

public class HiveSortRel
extends SortRel
implements HiveRel {
    public static final HiveSortRelFactory HIVE_SORT_REL_FACTORY = new HiveSortRelFactory();
    private ImmutableMap<Integer, RexNode> mapOfInputRefToRexCall;

    public HiveSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, TraitsUtil.getSortTraitSet(cluster, traitSet, collation), child, collation, offset, fetch);
    }

    public HiveSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)newCollation);
        return new HiveSortRel(this.getCluster(), traitSet, newInput, canonizedCollation, offset, fetch);
    }

    public RexNode getFetchExpr() {
        return this.fetch;
    }

    public void setInputRefToCallMap(ImmutableMap<Integer, RexNode> refToCall) {
        this.mapOfInputRefToRexCall = refToCall;
    }

    public Map<Integer, RexNode> getInputRefToCallMap() {
        return this.mapOfInputRefToRexCall;
    }

    @Override
    public void implement(HiveRel.Implementor implementor) {
    }

    private static class HiveSortRelFactory
    implements RelFactories.SortFactory {
        private HiveSortRelFactory() {
        }

        public RelNode createSort(RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            return new HiveSortRel(child.getCluster(), traits, child, collation, offset, fetch);
        }
    }
}

