/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.rules;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.optiq.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveFilterRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.rules.PartitionPruner;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptRuleOperandChildren;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public class HivePartitionPrunerRule
extends RelOptRule {
    HiveConf conf;

    public HivePartitionPrunerRule(HiveConf conf) {
        super(HivePartitionPrunerRule.operand(HiveFilterRel.class, (RelOptRuleOperand)HivePartitionPrunerRule.operand(HiveTableScanRel.class, (RelOptRuleOperandChildren)HivePartitionPrunerRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.conf = conf;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveFilterRel filter = (HiveFilterRel)call.rel(0);
        HiveTableScanRel tScan = (HiveTableScanRel)call.rel(1);
        this.perform(call, filter, tScan);
    }

    protected void perform(RelOptRuleCall call, FilterRelBase filter, HiveTableScanRel tScan) {
        RelOptHiveTable hiveTable = (RelOptHiveTable)tScan.getTable();
        RexNode predicate = filter.getCondition();
        Pair<RexNode, RexNode> predicates = PartitionPruner.extractPartitionPredicates(filter.getCluster(), hiveTable, predicate);
        RexNode partColExpr = (RexNode)predicates.left;
        hiveTable.computePartitionList(this.conf, partColExpr);
    }
}

