/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class ColumnAccessAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)ColumnAccessAnalyzer.class.getName());
    private final ParseContext pGraphContext;

    public ColumnAccessAnalyzer() {
        this.pGraphContext = null;
    }

    public ColumnAccessAnalyzer(ParseContext pactx) {
        this.pGraphContext = pactx;
    }

    public ColumnAccessInfo analyzeColumnAccess() throws SemanticException {
        ColumnAccessInfo columnAccessInfo = new ColumnAccessInfo();
        HashMap<TableScanOperator, Table> topOps = this.pGraphContext.getTopToTable();
        for (TableScanOperator op : topOps.keySet()) {
            PrunedPartitionList parts;
            Table table = (Table)topOps.get(op);
            String tableName = table.getCompleteName();
            List<String> referenced = op.getReferencedColumns();
            for (String column : referenced) {
                columnAccessInfo.add(tableName, column);
            }
            if (!table.isPartitioned() || (parts = this.pGraphContext.getPrunedPartitions(table.getTableName(), op)).getReferredPartCols() == null) continue;
            for (String partKey : parts.getReferredPartCols()) {
                columnAccessInfo.add(tableName, partKey);
            }
        }
        return columnAccessInfo;
    }
}

