/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RelOptTableImpl
implements Prepare.PreparingTable {
    private final RelOptSchema schema;
    private final RelDataType rowType;
    private final Table table;
    private final Function<Class, Expression> expressionFunction;
    private final ImmutableList<String> names;
    private final Double rowCount;

    private RelOptTableImpl(RelOptSchema schema, RelDataType rowType, List<String> names, Table table, Function<Class, Expression> expressionFunction, Double rowCount) {
        this.schema = schema;
        this.rowType = (RelDataType)Preconditions.checkNotNull((Object)rowType);
        this.names = ImmutableList.copyOf(names);
        this.table = table;
        this.expressionFunction = expressionFunction;
        this.rowCount = rowCount;
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, List<String> names, Expression expression) {
        Function expressionFunction = Functions.constant((Object)expression);
        return new RelOptTableImpl(schema, rowType, names, null, (Function<Class, Expression>)expressionFunction, null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, Table table, Path path) {
        MySchemaPlus schemaPlus = MySchemaPlus.create(path);
        Function<Class, Expression> expressionFunction = RelOptTableImpl.getClassExpressionFunction(schemaPlus, (String)Util.last(path).left, table);
        return new RelOptTableImpl(schema, rowType, Pair.left(path), table, expressionFunction, table.getStatistic().getRowCount());
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, CalciteSchema.TableEntry tableEntry, Double rowCount) {
        Table table = tableEntry.getTable();
        Function<Class, Expression> expressionFunction = RelOptTableImpl.getClassExpressionFunction(tableEntry, table);
        return new RelOptTableImpl(schema, rowType, tableEntry.path(), table, expressionFunction, rowCount);
    }

    private static Function<Class, Expression> getClassExpressionFunction(CalciteSchema.TableEntry tableEntry, Table table) {
        return RelOptTableImpl.getClassExpressionFunction(tableEntry.schema.plus(), tableEntry.name, table);
    }

    private static Function<Class, Expression> getClassExpressionFunction(final SchemaPlus schema, final String tableName, final Table table) {
        if (table instanceof QueryableTable) {
            final QueryableTable queryableTable = (QueryableTable)table;
            return new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return queryableTable.getExpression(schema, tableName, clazz);
                }
            };
        }
        if (table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable) {
            return new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return Schemas.tableExpression(schema, Object[].class, tableName, table.getClass());
                }
            };
        }
        if (table instanceof StreamableTable) {
            return RelOptTableImpl.getClassExpressionFunction(schema, tableName, ((StreamableTable)table).stream());
        }
        return new Function<Class, Expression>(){

            public Expression apply(Class input) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, Table table) {
        assert (table instanceof TranslatableTable || table instanceof ScannableTable || table instanceof ModifiableTable);
        return new RelOptTableImpl(schema, rowType, (List<String>)ImmutableList.of(), table, null, null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isInstance(this.table)) {
            return clazz.cast(this.table);
        }
        if (clazz == CalciteSchema.class) {
            return clazz.cast(Schemas.subSchema(((CalciteCatalogReader)this.schema).rootSchema, Util.skipLast(this.getQualifiedName())));
        }
        return null;
    }

    @Override
    public Expression getExpression(Class clazz) {
        if (this.expressionFunction == null) {
            return null;
        }
        return (Expression)this.expressionFunction.apply((Object)clazz);
    }

    @Override
    public RelOptTable extend(List<RelDataTypeField> extendedFields) {
        if (this.table instanceof ExtensibleTable) {
            Table extendedTable = ((ExtensibleTable)this.table).extend(extendedFields);
            RelDataType extendedRowType = extendedTable.getRowType(this.schema.getTypeFactory());
            return new RelOptTableImpl(this.schema, extendedRowType, (List<String>)this.names, extendedTable, this.expressionFunction, this.rowCount);
        }
        throw new RuntimeException("Cannot extend " + this.table);
    }

    @Override
    public double getRowCount() {
        Double rowCount;
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.table != null && (rowCount = this.table.getStatistic().getRowCount()) != null) {
            return rowCount;
        }
        return 100.0;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        if (this.table instanceof TranslatableTable) {
            return ((TranslatableTable)this.table).toRel(context, this);
        }
        RelOptCluster cluster = context.getCluster();
        if (this.table instanceof QueryableTable) {
            return EnumerableTableScan.create(cluster, this);
        }
        if (this.table instanceof ScannableTable || this.table instanceof FilterableTable || this.table instanceof ProjectableFilterableTable) {
            return LogicalTableScan.create(cluster, this);
        }
        return EnumerableTableScan.create(cluster, this);
    }

    @Override
    public List<RelCollation> getCollationList() {
        if (this.table != null) {
            return this.table.getStatistic().getCollations();
        }
        return ImmutableList.of();
    }

    @Override
    public RelDistribution getDistribution() {
        if (this.table != null) {
            return this.table.getStatistic().getDistribution();
        }
        return RelDistributionTraitDef.INSTANCE.getDefault();
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        if (this.table != null) {
            return this.table.getStatistic().isKey(columns);
        }
        return false;
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        switch (modality) {
            case STREAM: {
                return this.table instanceof StreamableTable;
            }
        }
        return !(this.table instanceof StreamableTable);
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        int i = this.rowType.getFieldNames().indexOf(columnName);
        if (i >= 0) {
            for (RelCollation collation : this.table.getStatistic().getCollations()) {
                RelFieldCollation fieldCollation = collation.getFieldCollations().get(0);
                if (fieldCollation.getFieldIndex() != i) continue;
                return RelOptTableImpl.monotonicity(fieldCollation.direction);
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    private static SqlMonotonicity monotonicity(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: {
                return SqlMonotonicity.INCREASING;
            }
            case STRICTLY_ASCENDING: {
                return SqlMonotonicity.STRICTLY_INCREASING;
            }
            case DESCENDING: {
                return SqlMonotonicity.DECREASING;
            }
            case STRICTLY_DESCENDING: {
                return SqlMonotonicity.STRICTLY_DECREASING;
            }
            case CLUSTERED: {
                return SqlMonotonicity.MONOTONIC;
            }
        }
        throw new AssertionError((Object)("unknown: " + (Object)((Object)direction)));
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }

    private static class MySchemaPlus
    implements SchemaPlus {
        private final SchemaPlus parent;
        private final String name;
        private final Schema schema;

        public MySchemaPlus(SchemaPlus parent, String name, Schema schema) {
            this.parent = parent;
            this.name = name;
            this.schema = schema;
        }

        public static MySchemaPlus create(Path path) {
            Pair<String, Schema> pair = Util.last(path);
            MySchemaPlus parent = path.size() == 1 ? null : MySchemaPlus.create(path.parent());
            return new MySchemaPlus(parent, (String)pair.left, (Schema)pair.right);
        }

        @Override
        public SchemaPlus getParentSchema() {
            return this.parent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            Schema subSchema = this.schema.getSubSchema(name);
            return subSchema == null ? null : new MySchemaPlus(this, name, subSchema);
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Table table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, org.apache.calcite.schema.Function function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Lattice lattice) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMutable() {
            return this.schema.isMutable();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return null;
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCacheEnabled() {
            return false;
        }

        @Override
        public Table getTable(String name) {
            return this.schema.getTable(name);
        }

        @Override
        public Set<String> getTableNames() {
            return this.schema.getTableNames();
        }

        @Override
        public Collection<org.apache.calcite.schema.Function> getFunctions(String name) {
            return this.schema.getFunctions(name);
        }

        @Override
        public Set<String> getFunctionNames() {
            return this.schema.getFunctionNames();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return this.schema.getSubSchemaNames();
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return this.schema.getExpression(parentSchema, name);
        }

        @Override
        public boolean contentsHaveChangedSince(long lastCheck, long now) {
            return this.schema.contentsHaveChangedSince(lastCheck, now);
        }
    }
}

