/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.configuration;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.broker.iface.SubscopedBrokerBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.ImmutableWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;

public class WorkUnitState
extends State {
    private static final String FINAL_CONSTRUCT_STATE_PREFIX = "construct.final.state.";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Gson GSON = new Gson();
    private final WorkUnit workUnit;
    private State jobState;
    private final transient SharedResourcesBroker<GobblinScopeTypes> taskBroker;

    public String getOutputFilePath() {
        return this.workUnit.getOutputFilePath();
    }

    public WorkUnitState() {
        this.workUnit = WorkUnit.createEmpty();
        this.jobState = new State();
        this.taskBroker = null;
    }

    @Deprecated
    public WorkUnitState(WorkUnit workUnit) {
        this.workUnit = workUnit;
        this.jobState = new State();
        this.taskBroker = null;
    }

    public WorkUnitState(WorkUnit workUnit, State jobState) {
        this(workUnit, jobState, WorkUnitState.buildTaskBroker(null, jobState, workUnit));
    }

    public WorkUnitState(WorkUnit workUnit, State jobState, SubscopedBrokerBuilder<GobblinScopeTypes, ?> taskBrokerBuilder) {
        this(workUnit, jobState, WorkUnitState.buildTaskBroker(taskBrokerBuilder, jobState, workUnit));
    }

    public WorkUnitState(WorkUnit workUnit, State jobState, SharedResourcesBroker<GobblinScopeTypes> taskBroker) {
        this.workUnit = workUnit;
        this.jobState = jobState;
        this.taskBroker = taskBroker;
    }

    private static SharedResourcesBroker<GobblinScopeTypes> buildTaskBroker(SubscopedBrokerBuilder<GobblinScopeTypes, ?> taskBrokerBuilder, State jobState, WorkUnit workUnit) {
        return taskBrokerBuilder == null ? null : (SharedResourcesBroker<GobblinScopeTypes>)taskBrokerBuilder.build();
    }

    public SharedResourcesBroker<GobblinScopeTypes> getTaskBroker() {
        if (this.taskBroker == null) {
            throw new UnsupportedOperationException("Task broker is only available within a task. If this exception was thrown from within a task, the JobLauncher did not specify a task broker.");
        }
        return this.taskBroker;
    }

    @Nullable
    public SharedResourcesBroker<GobblinScopeTypes> getTaskBrokerNullable() {
        return this.taskBroker;
    }

    public WorkUnit getWorkunit() {
        return new ImmutableWorkUnit(this.workUnit);
    }

    public void setWuProperties(Properties commonProps, Properties specProps) {
        this.workUnit.setProps(commonProps, specProps);
    }

    public WorkingState getWorkingState() {
        return WorkingState.valueOf(this.getProp("workunit.working.state", WorkingState.PENDING.toString()));
    }

    public void setWorkingState(WorkingState state) {
        this.setProp("workunit.working.state", state.toString());
    }

    public JsonElement getActualHighWatermark() {
        if (!this.contains("workunit.state.actual.high.water.mark")) {
            return null;
        }
        return JSON_PARSER.parse(this.getProp("workunit.state.actual.high.water.mark"));
    }

    public <T extends Watermark> T getActualHighWatermark(Class<T> watermarkClass, Gson gson) {
        JsonElement json = this.getActualHighWatermark();
        if (json == null && (json = this.workUnit.getLowWatermark()) == null) {
            return null;
        }
        return (T)((Watermark)gson.fromJson(json, watermarkClass));
    }

    public <T extends Watermark> T getActualHighWatermark(Class<T> watermarkClass) {
        return this.getActualHighWatermark(watermarkClass, GSON);
    }

    public void setActualHighWatermark(Watermark watermark) {
        this.setProp("workunit.state.actual.high.water.mark", watermark.toJson().toString());
    }

    public void backoffActualHighWatermark() {
        JsonElement lowWatermark = this.workUnit.getLowWatermark();
        if (lowWatermark == null) {
            return;
        }
        this.setProp("workunit.state.actual.high.water.mark", lowWatermark.toString());
    }

    @Deprecated
    public long getHighWaterMark() {
        return this.getPropAsLong("workunit.state.runtime.high.water.mark", -1L);
    }

    @Deprecated
    public void setHighWaterMark(long value) {
        this.setProp("workunit.state.runtime.high.water.mark", value);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.jobState.getProperties());
        props.putAll((Map<?, ?>)this.workUnit.getProperties());
        props.putAll((Map<?, ?>)super.getProperties());
        return props;
    }

    @Override
    public String getProp(String key) {
        String value = super.getProp(key);
        if (value == null) {
            value = this.workUnit.getProp(key);
        }
        if (value == null) {
            value = this.jobState.getProp(key);
        }
        return value;
    }

    @Override
    public String getProp(String key, String def) {
        String value = super.getProp(key);
        if (value == null) {
            value = this.workUnit.getProp(key);
        }
        if (value == null) {
            value = this.jobState.getProp(key, def);
        }
        return value;
    }

    @Override
    @Deprecated
    protected String getProperty(String key) {
        return this.getProp(key);
    }

    @Override
    @Deprecated
    protected String getProperty(String key, String def) {
        return this.getProp(key, def);
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet set = Sets.newHashSet(super.getPropertyNames());
        set.addAll(this.workUnit.getPropertyNames());
        set.addAll(this.jobState.getPropertyNames());
        return set;
    }

    @Override
    public boolean contains(String key) {
        return super.contains(key) || this.workUnit.contains(key) || this.jobState.contains(key);
    }

    @Override
    public void removeProp(String key) {
        super.removeProp(key);
        this.workUnit.removeProp(key);
        this.jobState.removeProp(key);
    }

    @Override
    public void removePropsWithPrefix(String prefix) {
        super.removePropsWithPrefix(prefix);
        this.workUnit.removePropsWithPrefix(prefix);
        this.jobState.removePropsWithPrefix(prefix);
    }

    public Extract getExtract() {
        return new Extract(this.workUnit.getExtract());
    }

    public State getPreviousTableState() {
        return this.getExtract().getPreviousTableState();
    }

    public void setJobState(State jobState) {
        this.jobState = jobState;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.workUnit.readFields(in);
        super.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.workUnit.write(out);
        super.write(out);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WorkUnitState)) {
            return false;
        }
        WorkUnitState other = (WorkUnitState)object;
        return (this.workUnit == null && other.workUnit == null || this.workUnit != null && this.workUnit.equals(other.workUnit)) && (this.jobState == null && other.jobState == null || this.jobState != null && this.jobState.equals(other.jobState)) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.workUnit == null ? 0 : this.workUnit.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + "\nWorkUnit: " + this.getWorkunit().toString() + "\nExtract: " + this.getExtract().toString() + "\nJobState: " + this.jobState.toString();
    }

    public void addFinalConstructState(String infix, State finalConstructState) {
        for (String property : finalConstructState.getPropertyNames()) {
            if (Strings.isNullOrEmpty((String)infix)) {
                this.setProp(FINAL_CONSTRUCT_STATE_PREFIX + property, finalConstructState.getProp(property));
                continue;
            }
            this.setProp(FINAL_CONSTRUCT_STATE_PREFIX + infix + "." + property, finalConstructState.getProp(property));
        }
    }

    public State getFinalConstructStates() {
        State constructState = new State();
        for (String property : this.getPropertyNames()) {
            if (!property.startsWith(FINAL_CONSTRUCT_STATE_PREFIX)) continue;
            constructState.setProp(property.substring(FINAL_CONSTRUCT_STATE_PREFIX.length()), this.getProp(property));
        }
        return constructState;
    }

    public State getJobState() {
        return this.jobState;
    }

    public static enum WorkingState {
        PENDING,
        RUNNING,
        SUCCESSFUL,
        COMMITTED,
        FAILED,
        CANCELLED,
        SKIPPED;

    }
}

