/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.publisher.DataPublisher;

public abstract class SingleTaskDataPublisher
extends DataPublisher {
    public SingleTaskDataPublisher(State state) {
        super(state);
    }

    public abstract void publishData(WorkUnitState var1) throws IOException;

    public abstract void publishMetadata(WorkUnitState var1) throws IOException;

    public void publish(WorkUnitState state) throws IOException {
        this.publishMetadata(state);
        this.publishData(state);
    }

    public static SingleTaskDataPublisher getInstance(Class<? extends DataPublisher> dataPublisherClass, State state) throws ReflectiveOperationException {
        Preconditions.checkArgument((boolean)SingleTaskDataPublisher.class.isAssignableFrom(dataPublisherClass), (Object)String.format("Cannot instantiate %s since it does not extend %s", dataPublisherClass.getSimpleName(), SingleTaskDataPublisher.class.getSimpleName()));
        return (SingleTaskDataPublisher)DataPublisher.getInstance(dataPublisherClass, state);
    }
}

