/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.simplejson;

import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJsonExtractor
implements Extractor<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJsonExtractor.class);
    private static final String SOURCE_FILE_KEY = "source.file";
    private final WorkUnitState workUnitState;
    private final FileObject fileObject;
    private final BufferedReader bufferedReader;
    private final Closer closer = Closer.create();

    public SimpleJsonExtractor(WorkUnitState workUnitState) throws FileSystemException {
        this.workUnitState = workUnitState;
        if (workUnitState.getPropAsBoolean("source.conn.use.authentication", false)) {
            StaticUserAuthenticator auth = new StaticUserAuthenticator(workUnitState.getProp("source.conn.domain", ""), workUnitState.getProp("source.conn.username"), PasswordManager.getInstance((State)workUnitState).readPassword(workUnitState.getProp("source.conn.password")));
            FileSystemOptions opts = new FileSystemOptions();
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)auth);
            this.fileObject = VFS.getManager().resolveFile(workUnitState.getProp(SOURCE_FILE_KEY), opts);
        } else {
            this.fileObject = VFS.getManager().resolveFile(workUnitState.getProp(SOURCE_FILE_KEY));
        }
        LOGGER.info("Opening file " + this.fileObject.getURL().toString());
        this.bufferedReader = (BufferedReader)this.closer.register((Closeable)new BufferedReader(new InputStreamReader(this.fileObject.getContent().getInputStream(), ConfigurationKeys.DEFAULT_CHARSET_ENCODING)));
    }

    public String getSchema() {
        return this.workUnitState.getProp("source.schema");
    }

    public String readRecord(@Deprecated String reuse) throws DataRecordException, IOException {
        return this.bufferedReader.readLine();
    }

    public long getExpectedRecordCount() {
        return 0L;
    }

    public long getHighWatermark() {
        return 0L;
    }

    public void close() throws IOException {
        try {
            this.closer.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to close the input stream", (Throwable)ioe);
        }
        try {
            this.fileObject.close();
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to close the file object", (Throwable)ioe);
        }
    }
}

