/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.IConfiguration;
import org.testng.internal.Utils;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.log4testng.Logger;

public class ThreadUtil {
    public static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(IConfiguration configuration, String name, List<? extends Runnable> tasks, int threadPoolSize, long timeout) {
        Utils.log("ThreadUtil", 2, "Starting executor timeOut:" + timeout + "ms workers:" + tasks.size() + " threadPoolSize:" + threadPoolSize);
        ExecutorService pooledExecutor = configuration.getExecutorServiceFactory().create(threadPoolSize, threadPoolSize, timeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new TestNGThreadFactory(name));
        List callables = Lists.newArrayList();
        for (Runnable runnable : tasks) {
            callables.add(() -> {
                task.run();
                return null;
            });
        }
        try {
            if (timeout != 0L) {
                pooledExecutor.invokeAll(callables, timeout, TimeUnit.MILLISECONDS);
            } else {
                pooledExecutor.invokeAll(callables);
            }
        }
        catch (InterruptedException handled) {
            Logger.getLogger(ThreadUtil.class).error(handled.getMessage(), handled);
            Thread.currentThread().interrupt();
        }
        finally {
            pooledExecutor.shutdown();
        }
    }

    public static String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return thread.getName() + "@" + thread.hashCode();
    }

    public static ExecutorService createExecutor(IConfiguration config, int threadCount, String threadFactoryName) {
        TestNGThreadFactory tf = new TestNGThreadFactory("method=" + threadFactoryName);
        return config.getExecutorServiceFactory().create(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), tf);
    }
}

