/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.secret;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import com.keepersecurity.secretsManager.core.KeeperSecrets;
import com.keepersecurity.secretsManager.core.Notation;
import com.keepersecurity.secretsManager.core.SecretsManager;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.vault.ksm.GuacamoleExceptionSupplier;
import org.apache.guacamole.vault.ksm.conf.KsmConfigurationService;
import org.apache.guacamole.vault.ksm.secret.KsmRecordService;
import org.apache.guacamole.vault.ksm.secret.UserLogin;
import org.apache.guacamole.vault.secret.WindowsUsername;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsmClient {
    private static final Logger logger = LoggerFactory.getLogger(KsmClient.class);
    @Inject
    private KsmConfigurationService confService;
    @Inject
    private KsmRecordService recordService;
    private static final String KEEPER_NOTATION_DOC_URL = "https://docs.keeper.io/secrets-manager/secrets-manager/about/keeper-notation";
    private static final Pattern KEEPER_FILE_NOTATION = Pattern.compile("^(keeper://)?[^/]*/file/.+");
    private final SecretsManagerOptions ksmConfig;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final long cacheInterval;
    private volatile long cacheTimestamp = 0L;
    private KeeperSecrets cachedSecrets = null;
    private final Map<String, KeeperRecord> cachedRecordsByUid = new HashMap<String, KeeperRecord>();
    private final Map<String, KeeperRecord> cachedRecordsByHost = new HashMap<String, KeeperRecord>();
    private final Set<String> cachedAmbiguousHosts = new HashSet<String>();
    private final Map<UserLogin, KeeperRecord> cachedRecordsByUser = new HashMap<UserLogin, KeeperRecord>();
    private final Set<UserLogin> cachedAmbiguousUsers = new HashSet<UserLogin>();
    private final Map<String, KeeperRecord> cachedRecordsByDomain = new HashMap<String, KeeperRecord>();
    private final Set<String> cachedAmbiguousDomains = new HashSet<String>();

    @AssistedInject
    public KsmClient(@Assisted SecretsManagerOptions ksmConfig, @Assisted long apiInterval) {
        this.ksmConfig = ksmConfig;
        this.cacheInterval = apiInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCache() throws GuacamoleException {
        long currentTime = System.currentTimeMillis();
        this.cacheLock.readLock().lock();
        try {
            if (currentTime - this.cacheTimestamp < this.cacheInterval) {
                return;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        this.cacheLock.writeLock().lock();
        try {
            if (currentTime - this.cacheTimestamp < this.cacheInterval) {
                return;
            }
            KeeperSecrets secrets = SecretsManager.getSecrets((SecretsManagerOptions)this.ksmConfig);
            List records = secrets.getRecords();
            this.cachedSecrets = secrets;
            this.cachedRecordsByUid.clear();
            this.cachedAmbiguousHosts.clear();
            this.cachedRecordsByHost.clear();
            this.cachedAmbiguousUsers.clear();
            this.cachedRecordsByUser.clear();
            this.cachedAmbiguousDomains.clear();
            this.cachedRecordsByDomain.clear();
            boolean shouldSplitUsernames = this.confService.getSplitWindowsUsernames();
            boolean shouldMatchByDomain = this.confService.getMatchUserRecordsByDomain();
            records.forEach(record -> {
                WindowsUsername usernameAndDomain;
                this.cachedRecordsByUid.put(record.getRecordUid(), (KeeperRecord)record);
                String hostname = this.recordService.getHostname((KeeperRecord)record);
                this.addRecordForHost((KeeperRecord)record, hostname);
                String domain = this.recordService.getDomain((KeeperRecord)record);
                this.addRecordForDomain((KeeperRecord)record, domain);
                String username = this.recordService.getUsername((KeeperRecord)record);
                if (username != null && domain == null && shouldSplitUsernames && (usernameAndDomain = WindowsUsername.splitWindowsUsernameFromDomain((String)username)).hasDomain()) {
                    domain = usernameAndDomain.getDomain();
                    username = usernameAndDomain.getUsername();
                    this.addRecordForDomain((KeeperRecord)record, domain);
                }
                if (!shouldMatchByDomain) {
                    domain = null;
                }
                if (hostname == null) {
                    this.addRecordForLogin((KeeperRecord)record, username, domain);
                }
            });
            this.cacheTimestamp = System.currentTimeMillis();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private void addRecordForDomain(KeeperRecord record, String domain) {
        if (domain == null) {
            return;
        }
        KeeperRecord existing = this.cachedRecordsByDomain.putIfAbsent(domain, record);
        if (existing != null && record != existing) {
            this.cachedAmbiguousDomains.add(domain);
        }
    }

    private void addRecordForHost(KeeperRecord record, String hostname) {
        if (hostname == null) {
            return;
        }
        KeeperRecord existing = this.cachedRecordsByHost.putIfAbsent(hostname, record);
        if (existing != null && record != existing) {
            this.cachedAmbiguousHosts.add(hostname);
        }
    }

    private void addRecordForLogin(KeeperRecord record, String username, String domain) {
        if (username == null) {
            return;
        }
        UserLogin userDomain = new UserLogin(username, domain);
        KeeperRecord existing = this.cachedRecordsByUser.putIfAbsent(userDomain, record);
        if (existing != null && record != existing) {
            this.cachedAmbiguousUsers.add(userDomain);
        }
    }

    public Collection<KeeperRecord> getRecords() throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            Collection<KeeperRecord> collection = Collections.unmodifiableCollection(this.cachedRecordsByUid.values());
            return collection;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecord(String uid) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            KeeperRecord keeperRecord = this.cachedRecordsByUid.get(uid);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecordByHost(String hostname) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            if (this.cachedAmbiguousHosts.contains(hostname)) {
                logger.debug("The hostname/address \"{}\" is referenced by multiple Keeper records and cannot be used to locate individual secrets.", (Object)hostname);
                KeeperRecord keeperRecord = null;
                return keeperRecord;
            }
            KeeperRecord keeperRecord = this.cachedRecordsByHost.get(hostname);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeeperRecord getRecordByLogin(String username, String domain) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        UserLogin userDomain = new UserLogin(username, domain);
        try {
            if (this.cachedAmbiguousUsers.contains(userDomain)) {
                logger.debug("The username \"{}\" with domain \"{}\" is referenced by multiple Keeper records and cannot be used to locate individual secrets.", (Object)username, (Object)domain);
                KeeperRecord keeperRecord = null;
                return keeperRecord;
            }
            KeeperRecord keeperRecord = this.cachedRecordsByUser.get(userDomain);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public KeeperRecord getRecordByDomain(String domain) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            if (this.cachedAmbiguousDomains.contains(domain)) {
                logger.debug("The domain \"{}\" is referenced by multiple Keeper records and cannot be used to locate individual secrets.", (Object)domain);
                KeeperRecord keeperRecord = null;
                return keeperRecord;
            }
            KeeperRecord keeperRecord = this.cachedRecordsByDomain.get(domain);
            return keeperRecord;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public Future<String> getSecret(String notation) throws GuacamoleException {
        return this.getSecret(notation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<String> getSecret(String notation, @Nullable GuacamoleExceptionSupplier<Future<String>> fallbackFunction) throws GuacamoleException {
        this.validateCache();
        this.cacheLock.readLock().lock();
        try {
            Matcher fileNotationMatcher = KEEPER_FILE_NOTATION.matcher(notation);
            if (fileNotationMatcher.matches()) {
                Future<String> future = this.recordService.download(Notation.getFile((KeeperSecrets)this.cachedSecrets, (String)notation));
                return future;
            }
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(Notation.getValue((KeeperSecrets)this.cachedSecrets, (String)notation));
            return completableFuture;
        }
        catch (Error e) {
            logger.warn("Record \"{}\" does not exist.", (Object)notation);
            logger.debug("Retrieval of record by Keeper notation failed.", (Throwable)e);
            if (fallbackFunction != null) {
                Future<String> future = fallbackFunction.get();
                return future;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        catch (Exception e) {
            logger.warn("\"{}\" is not valid Keeper notation. Please check the documentation at {} for valid formatting.", (Object)notation, (Object)KEEPER_NOTATION_DOC_URL);
            logger.debug("Provided Keeper notation could not be parsed.", (Throwable)e);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }
}

