/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;

/**
 * Run the {@code FileSystemContractBaseTest} tests against the emulator
 */
public class ITestNativeAzureFileSystemContractEmulator extends
    FileSystemContractBaseTest {
  private AzureBlobStorageTestAccount testAccount;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    testAccount = AzureBlobStorageTestAccount.createForEmulator();
    if (testAccount != null) {
      fs = testAccount.getFileSystem();
    }
  }

  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
    testAccount = AzureTestUtils.cleanup(testAccount);
    fs = null;
  }

  @Override
  protected void runTest() throws Throwable {
    if (testAccount != null) {
      super.runTest();
    }
  }
}
