/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(CurrentStateComputationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        if (cache == null || resourceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        CurrentStateOutput currentStateOutput = new CurrentStateOutput();
        for (LiveInstance instance : liveInstances.values()) {
            String instanceName = instance.getInstanceName();
            String instanceSessionId = instance.getEphemeralOwner();
            Map<String, Message> messages = cache.getMessages(instanceName);
            Map<String, Message> relayMessages = cache.getRelayMessages(instanceName);
            this.updatePendingMessages(instance, messages.values(), currentStateOutput, relayMessages.values(), resourceMap);
            Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, instanceSessionId);
            this.updateCurrentStates(instance, currentStateMap.values(), currentStateOutput, resourceMap);
        }
        event.addAttribute(AttributeName.CURRENT_STATE.name(), currentStateOutput);
    }

    private void updatePendingMessages(LiveInstance instance, Collection<Message> pendingMessages, CurrentStateOutput currentStateOutput, Collection<Message> pendingRelayMessages, Map<String, Resource> resourceMap) {
        Object partition;
        String partitionName;
        Resource resource;
        String resourceName;
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getEphemeralOwner();
        for (Message message : pendingMessages) {
            if (!Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType()) && !Message.MessageType.STATE_TRANSITION_CANCELLATION.name().equalsIgnoreCase(message.getMsgType()) || !instanceSessionId.equals(message.getTgtSessionId())) continue;
            resourceName = message.getResourceName();
            resource = resourceMap.get(resourceName);
            if (resource == null) {
                LogUtil.logInfo(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            if (!message.getBatchMessageMode()) {
                partitionName = message.getPartitionName();
                partition = resource.getPartition(partitionName);
                if (partition != null) {
                    this.setMessageState(currentStateOutput, resourceName, (Partition)partition, instanceName, message);
                } else {
                    LogUtil.logInfo(LOG, this._eventId, String.format("Ignore a pending message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                }
            } else {
                List<String> partitionNames = message.getPartitionNames();
                if (!partitionNames.isEmpty()) {
                    for (String partitionName2 : partitionNames) {
                        Partition partition2 = resource.getPartition(partitionName2);
                        if (partition2 != null) {
                            this.setMessageState(currentStateOutput, resourceName, partition2, instanceName, message);
                            continue;
                        }
                        LogUtil.logInfo(LOG, this._eventId, String.format("Ignore a pending message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                    }
                }
            }
            if (resource.getStateModelDefRef() == null) continue;
            currentStateOutput.setResourceStateModelDef(resourceName, resource.getStateModelDefRef());
        }
        for (Message message : pendingRelayMessages) {
            if (!message.isRelayMessage()) {
                LogUtil.logWarn(LOG, this._eventId, String.format("Not a relay message %s, ignored!", message.getMsgId()));
                continue;
            }
            resourceName = message.getResourceName();
            resource = resourceMap.get(resourceName);
            if (resource == null) {
                LogUtil.logInfo(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            if (!message.getBatchMessageMode()) {
                partitionName = message.getPartitionName();
                partition = resource.getPartition(partitionName);
                if (partition != null) {
                    currentStateOutput.setPendingRelayMessage(resourceName, (Partition)partition, instanceName, message);
                    continue;
                }
                LogUtil.logInfo(LOG, this._eventId, String.format("Ignore a pending relay message %s for a non-exist resource %s and partition %s", message.getMsgId(), resourceName, message.getPartitionName()));
                continue;
            }
            LogUtil.logWarn(LOG, this._eventId, String.format("A relay message %s should not be batched, ignored!", message.getMsgId()));
        }
    }

    private void updateCurrentStates(LiveInstance instance, Collection<CurrentState> currentStates, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap) {
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getEphemeralOwner();
        for (CurrentState currentState : currentStates) {
            if (!instanceSessionId.equals(currentState.getSessionId())) continue;
            String resourceName = currentState.getResourceName();
            String stateModelDefName = currentState.getStateModelDefRef();
            Resource resource = resourceMap.get(resourceName);
            if (resource == null) continue;
            if (stateModelDefName != null) {
                currentStateOutput.setResourceStateModelDef(resourceName, stateModelDefName);
            }
            currentStateOutput.setBucketSize(resourceName, currentState.getBucketSize());
            Map<String, String> partitionStateMap = currentState.getPartitionStateMap();
            for (String partitionName : partitionStateMap.keySet()) {
                String requestState;
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                currentStateOutput.setCurrentState(resourceName, partition, instanceName, currentState.getState(partitionName));
                currentStateOutput.setEndTime(resourceName, partition, instanceName, currentState.getEndTime(partitionName));
                String info = currentState.getInfo(partitionName);
                if (info != null) {
                    currentStateOutput.setInfo(resourceName, partition, instanceName, info);
                }
                if ((requestState = currentState.getRequestedState(partitionName)) == null) continue;
                currentStateOutput.setRequestedState(resourceName, partition, instanceName, requestState);
            }
        }
    }

    private void setMessageState(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, String instanceName, Message message) {
        if (Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType())) {
            currentStateOutput.setPendingMessage(resourceName, partition, instanceName, message);
        } else {
            currentStateOutput.setCancellationMessage(resourceName, partition, instanceName, message);
        }
    }
}

