/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.metadatastore.concurrency;

import java.util.Collections;
import java.util.List;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDistributedLeaderElection
implements IZkDataListener,
IZkStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZkDistributedLeaderElection.class);
    private static final String PREFIX = "MSDS_SERVER_";
    private final HelixZkClient _zkClient;
    private final String _basePath;
    private final ZNRecord _participantInfo;
    private ZNRecord _currentLeaderInfo;
    private String _myEphemeralSequentialPath;
    private volatile boolean _isLeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZkDistributedLeaderElection(HelixZkClient zkClient, String basePath, ZNRecord participantInfo) {
        ZkDistributedLeaderElection zkDistributedLeaderElection = this;
        synchronized (zkDistributedLeaderElection) {
            if (zkClient == null || zkClient.isClosed()) {
                throw new IllegalArgumentException("ZkClient cannot be null or closed!");
            }
            this._zkClient = zkClient;
            this._zkClient.setZkSerializer((ZkSerializer)new ZNRecordSerializer());
            if (basePath == null || basePath.isEmpty()) {
                throw new IllegalArgumentException("lockBasePath cannot be null or empty!");
            }
            this._basePath = basePath;
            this._participantInfo = participantInfo;
            this._isLeader = false;
        }
        this.init();
    }

    private void init() {
        try {
            this._zkClient.createPersistent(this._basePath, true);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            // empty catch block
        }
        this._myEphemeralSequentialPath = this._zkClient.create(this._basePath + "/MSDS_SERVER_", (Object)this._participantInfo, CreateMode.EPHEMERAL_SEQUENTIAL);
        if (this._myEphemeralSequentialPath == null) {
            throw new IllegalStateException("Unable to create ephemeral sequential node at path: " + this._basePath);
        }
        this.tryAcquiringLeadership();
    }

    private void tryAcquiringLeadership() {
        List children = this._zkClient.getChildren(this._basePath);
        Collections.sort(children);
        String leaderName = (String)children.get(0);
        this._currentLeaderInfo = (ZNRecord)this._zkClient.readData(this._basePath + "/" + leaderName, true);
        String[] myNameArray = this._myEphemeralSequentialPath.split("/");
        String myName = myNameArray[myNameArray.length - 1];
        if (leaderName.equals(myName)) {
            this._isLeader = true;
            LOG.info("{} acquired leadership! Info: {}", (Object)myName, (Object)this._currentLeaderInfo);
        } else {
            String beforeMe = (String)children.get(children.indexOf(myName) - 1);
            this._zkClient.subscribeDataChanges(this._basePath + "/" + beforeMe, (IZkDataListener)this);
        }
    }

    public synchronized boolean isLeader() {
        return this._isLeader;
    }

    public synchronized ZNRecord getCurrentLeaderInfo() {
        return this._currentLeaderInfo;
    }

    public synchronized void handleStateChanged(Watcher.Event.KeeperState state) {
        if (state == Watcher.Event.KeeperState.SyncConnected) {
            this.init();
        }
    }

    public void handleNewSession(String sessionId) {
    }

    public void handleSessionEstablishmentError(Throwable error) {
    }

    public void handleDataChange(String s, Object o) {
    }

    public void handleDataDeleted(String s) {
        this.tryAcquiringLeadership();
    }
}

