/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint.drop;

import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.constraint.drop.AlterTableDropConstraintDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterTableDropConstraintOperation
extends DDLOperation<AlterTableDropConstraintDesc> {
    public AlterTableDropConstraintOperation(DDLOperationContext context, AlterTableDropConstraintDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        if (!DDLUtils.allowOperationInReplicationScope(this.context.getDb(), ((AlterTableDropConstraintDesc)this.desc).getDbTableName(), null, ((AlterTableDropConstraintDesc)this.desc).getReplicationSpec())) {
            LOG.debug("DDLTask: Alter Table is skipped as table {} is newer than update", (Object)((AlterTableDropConstraintDesc)this.desc).getDbTableName());
            return 0;
        }
        try {
            this.context.getDb().dropConstraint(((AlterTableDropConstraintDesc)this.desc).getTableName().getDb(), ((AlterTableDropConstraintDesc)this.desc).getTableName().getTable(), ((AlterTableDropConstraintDesc)this.desc).getConstraintName());
        }
        catch (NoSuchObjectException e) {
            throw new HiveException((Throwable)e);
        }
        return 0;
    }
}

