/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.AckWork;
import org.apache.hadoop.hive.ql.exec.repl.PreAckTask;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckTask
extends Task<AckWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger LOG = LoggerFactory.getLogger(AckTask.class);

    @Override
    public int execute() {
        try {
            for (PreAckTask task : ((AckWork)this.work).getPreAckTasks()) {
                task.run();
            }
            Path ackPath = ((AckWork)this.work).getAckFilePath();
            Utils.create(ackPath, this.conf);
            this.LOG.info("Created ack file : {} ", (Object)ackPath);
        }
        catch (Exception e) {
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, ((AckWork)this.work).getAckFilePath().getParent().getParent().toString(), ((AckWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                this.LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.ACK;
    }

    public String getName() {
        return "ACK_TASK";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

