/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.COWWithClauseBuilder;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class CopyOnWriteDeleteRewriter
implements Rewriter<DeleteStatement> {
    private final HiveConf conf;
    protected final SqlGeneratorFactory sqlGeneratorFactory;
    private final COWWithClauseBuilder cowWithClauseBuilder;

    public CopyOnWriteDeleteRewriter(HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.conf = conf;
        this.cowWithClauseBuilder = new COWWithClauseBuilder();
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context context, DeleteStatement deleteBlock) throws SemanticException {
        ASTNode whereTree = deleteBlock.getWhereTree();
        String whereClause = "true";
        if (whereTree != null) {
            Tree wherePredicateNode = whereTree.getChild(0);
            whereClause = context.getTokenRewriteStream().toString(wherePredicateNode.getTokenStartIndex(), wherePredicateNode.getTokenStopIndex());
        }
        String filePathCol = HiveUtils.unparseIdentifier(VirtualColumn.FILE_PATH.getName(), (Configuration)this.conf);
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        this.cowWithClauseBuilder.appendWith(sqlGenerator, filePathCol, whereClause);
        sqlGenerator.append("insert into table ");
        sqlGenerator.append(sqlGenerator.getTargetTableFullName());
        sqlGenerator.appendPartitionColsOfTarget();
        sqlGenerator.append(" select ");
        sqlGenerator.appendAcidSelectColumns(Context.Operation.DELETE);
        sqlGenerator.removeLastChar();
        sqlGenerator.append(" from ");
        sqlGenerator.append(sqlGenerator.getTargetTableFullName());
        sqlGenerator.append("\nwhere ");
        sqlGenerator.append("( NOT(%s) OR (%s) IS NULL )".replace("%s", whereClause));
        sqlGenerator.append("\n");
        sqlGenerator.append("AND ").append(filePathCol);
        sqlGenerator.append(" IN ( select ").append(filePathCol).append(" from t )");
        sqlGenerator.append("\nunion all");
        sqlGenerator.append("\nselect * from t");
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(context, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        rewrittenCtx.setOperation(Context.Operation.DELETE);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.DELETE);
        rewrittenCtx.setEnableUnparse(false);
        return rr;
    }
}

