/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.secrets;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.hive.ql.secrets.SecretSource;

public class AWSSecretsManagerSecretSource
implements SecretSource {
    private volatile SecretCache cache = null;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String getURIScheme() {
        return "aws-sm";
    }

    @Override
    public String getSecret(URI uri) throws IOException {
        String secretsString;
        Preconditions.checkArgument((boolean)this.getURIScheme().equals(uri.getScheme()));
        this.initCache();
        String key = uri.getPath();
        key = key.substring(1);
        try {
            secretsString = this.cache.getSecretString(key);
        }
        catch (Exception e) {
            throw new IOException("Error trying to get secret", e);
        }
        if (secretsString == null) {
            throw new IOException("secret was not found");
        }
        try {
            JsonNode passwd = this.mapper.readTree(secretsString).get("password");
            if (passwd == null) {
                throw new IOException("Expected \"password\" field in secrets json.");
            }
            return passwd.asText();
        }
        catch (JsonProcessingException e) {
            throw new IOException("Exception while parsing secretstring as json. Check secret string stored.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache() {
        if (this.cache == null) {
            AWSSecretsManagerSecretSource aWSSecretsManagerSecretSource = this;
            synchronized (aWSSecretsManagerSecretSource) {
                if (this.cache == null) {
                    this.cache = new SecretCache();
                }
            }
        }
    }

    @VisibleForTesting
    void setCache(SecretCache cache) {
        this.cache = cache;
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

