/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.Compactor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.MRCompactor;

public class CompactorPipeline {
    private Compactor compactor;
    private final boolean isMR;

    public CompactorPipeline(Compactor compactor) {
        this.compactor = compactor;
        this.isMR = compactor instanceof MRCompactor;
    }

    CompactorPipeline addCompactor(Compactor newCompactor) {
        this.compactor = new FallbackCompactor(this.compactor, newCompactor);
        return this;
    }

    public boolean isMRCompaction() {
        return this.isMR;
    }

    public Boolean execute(CompactorContext input) throws IOException, HiveException, InterruptedException {
        return this.compactor.run(input);
    }

    static final class FallbackCompactor
    implements Compactor {
        private final Compactor primaryCompactor;
        private final Compactor secondaryCompactor;

        FallbackCompactor(Compactor primaryCompactor, Compactor secondaryCompactor) {
            this.primaryCompactor = primaryCompactor;
            this.secondaryCompactor = secondaryCompactor;
        }

        @Override
        public boolean run(CompactorContext context) throws IOException, HiveException, InterruptedException {
            boolean result = this.primaryCompactor.run(context);
            return !result ? this.secondaryCompactor.run(context) : result;
        }
    }
}

