/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.DirSearchFactory;
import org.apache.hadoop.hive.metastore.ldap.LdapSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapSearchFactory
implements DirSearchFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSearchFactory.class);

    @Override
    public DirSearch getInstance(Configuration conf, String principal, String password) throws AuthenticationException {
        try {
            DirContext ctx = LdapSearchFactory.createDirContext(conf, principal, password);
            return new LdapSearch(conf, ctx);
        }
        catch (NamingException e) {
            LOG.debug("Could not connect to the LDAP Server:Authentication failed for {}", (Object)principal);
            throw new AuthenticationException("Error validating LDAP user", e);
        }
    }

    private static DirContext createDirContext(Configuration conf, String principal, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String ldapUrl = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_URL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", principal);
        LOG.debug("Connecting using principal {} to ldap url {}", (Object)principal, (Object)ldapUrl);
        return new InitialDirContext(env);
    }
}

