/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.keys.JavaObjectIndexKey;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;

public class CacheJavaObjectIndexKey
extends JavaObjectIndexKey {
    private final CacheObject obj;
    private final CacheObjectValueContext valCtx;
    private byte[] serialized;
    private Object key;

    public CacheJavaObjectIndexKey(CacheObject obj, CacheObjectValueContext valCtx) {
        assert (obj != null);
        if (obj instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)obj).detachAllowed(true);
            obj = ((BinaryObjectImpl)obj).detach();
        }
        this.obj = obj;
        this.valCtx = valCtx;
    }

    @Override
    public Object key() {
        if (this.key == null) {
            this.key = this.obj.isPlatformType() ? this.obj.value(this.valCtx, false) : this.obj;
        }
        return this.key;
    }

    @Override
    public byte[] bytesNoCopy() {
        try {
            if (this.serialized == null) {
                if (this.obj.cacheObjectType() == 1) {
                    return this.obj.valueBytes(this.valCtx);
                }
                this.serialized = IndexProcessor.serializer.serialize(this.obj);
            }
            return this.serialized;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }
}

