/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.jetbrains.annotations.Nullable;

public class ScanNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row> {
    private final Iterable<Row> src;
    @Nullable
    private final Predicate<Row> filter;
    @Nullable
    private final Function<Row, Row> rowTransformer;
    private Iterator<Row> it;
    private int requested;
    private boolean inLoop;
    private boolean firstReq = true;

    public ScanNode(ExecutionContext<Row> ctx, RelDataType rowType, Iterable<Row> src) {
        this(ctx, rowType, src, null, null);
    }

    public ScanNode(ExecutionContext<Row> ctx, RelDataType rowType, Iterable<Row> src, @Nullable Predicate<Row> filter, @Nullable Function<Row, Row> rowTransformer) {
        super(ctx, rowType);
        this.src = src;
        this.filter = filter;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            if (this.firstReq) {
                try {
                    this.push();
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                this.firstReq = false;
            } else {
                this.context().execute(this::push, this::onError);
            }
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        Commons.closeQuiet(this.it);
        this.it = null;
        Commons.closeQuiet(this.src);
    }

    @Override
    protected void rewindInternal() {
        Commons.closeQuiet(this.it);
        this.it = null;
    }

    @Override
    public void register(List<Node<Row>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        this.inLoop = true;
        try {
            if (this.it == null) {
                this.it = this.src.iterator();
            }
            this.processNextBatch();
        }
        finally {
            this.inLoop = false;
        }
    }

    protected int processNextBatch() throws Exception {
        int processed = 0;
        while (this.requested > 0 && this.it.hasNext()) {
            this.checkState();
            Row r = this.it.next();
            if (this.filter == null || this.filter.test(r)) {
                --this.requested;
                if (this.rowTransformer != null) {
                    r = this.rowTransformer.apply(r);
                }
                this.downstream().push(r);
            }
            if (++processed != IN_BUFFER_SIZE || this.requested <= 0) continue;
            this.context().execute(this::push, this::onError);
            return processed;
        }
        if (this.requested > 0 && !this.it.hasNext()) {
            Commons.closeQuiet(this.it);
            this.it = null;
            this.requested = 0;
            this.downstream().end();
        }
        return processed;
    }

    @Nullable
    public Predicate<Row> filter() {
        return this.filter;
    }

    @Nullable
    public Function<Row, Row> rowTransformer() {
        return this.rowTransformer;
    }
}

