/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare.ddl;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.jetbrains.annotations.Nullable;

public class ColumnDefinition {
    private final String name;
    private final RelDataType type;
    private final Object dflt;

    public ColumnDefinition(String name, RelDataType type, @Nullable Object dflt) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.dflt = dflt;
    }

    public String name() {
        return this.name;
    }

    public RelDataType type() {
        return this.type;
    }

    @Nullable
    public Object defaultValue() {
        return this.dflt;
    }

    public boolean nullable() {
        return this.type.isNullable();
    }

    public Integer precision() {
        return TypeUtils.hasPrecision(this.type) ? Integer.valueOf(this.type.getPrecision()) : null;
    }

    public Integer scale() {
        return TypeUtils.hasScale(this.type) ? Integer.valueOf(this.type.getScale()) : null;
    }
}

